/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.util.MathUtils;

class FileNioMemData {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[131072];
    private static final ByteBuffer COMPRESSED_EMPTY_BLOCK;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final int id;
    private final boolean compress;
    private long length;
    private ByteBuffer[] data;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;

    FileNioMemData(String string, boolean bl) {
        this.name = string;
        this.id = string.hashCode();
        this.compress = bl;
        this.data = new ByteBuffer[0];
        this.lastModified = System.currentTimeMillis();
    }

    int getId() {
        return this.id;
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressLater(int n) {
        CompressItem compressItem = new CompressItem();
        compressItem.data = this;
        compressItem.page = n;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(compressItem, compressItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(int n) {
        ByteBuffer byteBuffer = this.data[n];
        if (byteBuffer.capacity() == 65536) {
            return;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(65536);
        if (byteBuffer != COMPRESSED_EMPTY_BLOCK) {
            CompressLZF compressLZF = LZF;
            synchronized (compressLZF) {
                byteBuffer.position(0);
                CompressLZF.expand(byteBuffer, byteBuffer2);
            }
        }
        this.data[n] = byteBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compress(int n) {
        ByteBuffer byteBuffer = this.data[n];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int n2 = LZF.compress(byteBuffer, 0, BUFFER, 0);
            byteBuffer = ByteBuffer.allocateDirect(n2);
            byteBuffer.put(BUFFER, 0, n2);
            this.data[n] = byteBuffer;
        }
    }

    void touch(boolean bl) throws IOException {
        if (this.isReadOnly || bl) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    void truncate(long l) {
        this.changeLength(l);
        long l2 = MathUtils.roundUpLong(l, 65536L);
        if (l2 != l) {
            int n = (int)(l >>> 16);
            this.expand(n);
            ByteBuffer byteBuffer = this.data[n];
            for (int i = (int)(l & 0xFFFFL); i < 65536; ++i) {
                byteBuffer.put(i, (byte)0);
            }
            if (this.compress) {
                this.compressLater(n);
            }
        }
    }

    private void changeLength(long l) {
        this.length = l;
        int n = (int)((l = MathUtils.roundUpLong(l, 65536L)) >>> 16);
        if (n != this.data.length) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[n];
            System.arraycopy(this.data, 0, byteBufferArray, 0, Math.min(this.data.length, byteBufferArray.length));
            for (int i = this.data.length; i < n; ++i) {
                byteBufferArray[i] = COMPRESSED_EMPTY_BLOCK;
            }
            this.data = byteBufferArray;
        }
    }

    long readWrite(long l, ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        long l2 = l + (long)n2;
        if (l2 > this.length) {
            if (bl) {
                this.changeLength(l2);
            } else {
                n2 = (int)(this.length - l);
            }
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer2;
            int n3 = (int)Math.min((long)n2, 65536L - (l & 0xFFFFL));
            int n4 = (int)(l >>> 16);
            this.expand(n4);
            ByteBuffer byteBuffer3 = this.data[n4];
            int n5 = (int)(l & 0xFFFFL);
            if (bl) {
                byteBuffer2 = byteBuffer.slice();
                byteBuffer2.position(n);
                byteBuffer2.limit(n + n3);
                byteBuffer3.position(n5);
                byteBuffer3.put(byteBuffer2);
            } else {
                byteBuffer2 = byteBuffer3.duplicate();
                byteBuffer2.position(n5);
                byteBuffer2.limit(n3 + n5);
                int n6 = byteBuffer.position();
                byteBuffer.position(n);
                byteBuffer.put(byteBuffer2);
                byteBuffer.position(n6);
            }
            if (this.compress) {
                this.compressLater(n4);
            }
            n += n3;
            l += (long)n3;
            n2 -= n3;
        }
        return l;
    }

    void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] byArray = new byte[65536];
        int n = LZF.compress(byArray, 65536, BUFFER, 0);
        COMPRESSED_EMPTY_BLOCK = ByteBuffer.allocateDirect(n);
        COMPRESSED_EMPTY_BLOCK.put(BUFFER, 0, n);
    }

    static class CompressItem {
        FileNioMemData data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.page ^ this.data.getId();
        }

        public boolean equals(Object object) {
            if (object instanceof CompressItem) {
                CompressItem compressItem = (CompressItem)object;
                return compressItem.data == this.data && compressItem.page == this.page;
            }
            return false;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int size;

        Cache(int n) {
            super(n, 0.75f, true);
            this.size = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry2) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem compressItem = (CompressItem)entry2.getKey();
            compressItem.data.compress(compressItem.page);
            return true;
        }
    }
}

