/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private final int index;

    public Parameter(int n) {
        this.index = n;
    }

    @Override
    public String getSQL() {
        return "?" + (this.index + 1);
    }

    @Override
    public void setValue(Value value, boolean bl) {
        this.value = value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    @Override
    public Value getValue(Session session2) {
        return this.getParamValue();
    }

    @Override
    public int getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return -1;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    @Override
    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    @Override
    public Expression optimize(Session session2) {
        if (session2.getDatabase().getMode().treatEmptyStringsAsNull && this.value != null && this.value instanceof ValueString) {
            this.value = ValueString.get(this.value.getString(), true);
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueSet() {
        return this.value != null;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public int getScale() {
        if (this.value != null) {
            return this.value.getScale();
        }
        if (this.column != null) {
            return this.column.getScale();
        }
        return 0;
    }

    @Override
    public long getPrecision() {
        if (this.value != null) {
            return this.value.getPrecision();
        }
        if (this.column != null) {
            return this.column.getPrecision();
        }
        return 0L;
    }

    @Override
    public int getDisplaySize() {
        if (this.value != null) {
            return this.value.getDisplaySize();
        }
        if (this.column != null) {
            return this.column.getDisplaySize();
        }
        return 0;
    }

    @Override
    public void updateAggregate(Session session2) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression getNotIfPossible(Session session2) {
        return new Comparison(session2, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

