/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private final Expression[] list;

    public ExpressionList(Expression[] expressionArray) {
        this.list = expressionArray;
    }

    @Override
    public Value getValue(Session session2) {
        Value[] valueArray = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            valueArray[i] = this.list[i].getValue(session2);
        }
        return ValueArray.get(valueArray);
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.list) {
            expression.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session2) {
        boolean bl = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression expression = this.list[i].optimize(session2);
            if (!expression.isConstant()) {
                bl = false;
            }
            this.list[i] = expression;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session2));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.list) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Expression expression : this.list) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        if (this.list.length == 1) {
            statementBuilder.append(',');
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session2) {
        for (Expression expression : this.list) {
            expression.updateAggregate(session2);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.list) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = 1;
        for (Expression expression : this.list) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public Expression[] getExpressionColumns(Session session2) {
        Expression[] expressionArray = new ExpressionColumn[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Expression expression = this.list[i];
            Column column = new Column("C" + (i + 1), expression.getType(), expression.getPrecision(), expression.getScale(), expression.getDisplaySize());
            expressionArray[i] = new ExpressionColumn(session2.getDatabase(), column);
        }
        return expressionArray;
    }
}

