/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInConstantSet
extends Condition {
    private Expression left;
    private int queryLevel;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;

    public ConditionInConstantSet(final Session session2, Expression expression, ArrayList<Expression> arrayList) {
        this.left = expression;
        this.valueList = arrayList;
        this.valueSet = new TreeSet<Value>(new Comparator<Value>(){

            @Override
            public int compare(Value value, Value value2) {
                return session2.getDatabase().compare(value, value2);
            }
        });
        int n = expression.getType();
        for (Expression expression2 : arrayList) {
            this.valueSet.add(expression2.getValue(session2).convertTo(n));
        }
    }

    @Override
    public Value getValue(Session session2) {
        boolean bl;
        Value value = this.left.getValue(session2);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl2 = this.valueSet.contains(value);
        if (!bl2 && (bl = this.valueSet.contains(ValueNull.INSTANCE))) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session2) {
        this.left = this.left.optimize(session2);
        return this;
    }

    @Override
    public void createIndexConditions(Session session2, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session2.getDatabase().getSettings().optimizeInList) {
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
            return;
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.left.getSQL()).append(" IN(");
        for (Expression expression : this.valueList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    @Override
    public void updateAggregate(Session session2) {
        this.left.updateAggregate(session2);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        return n;
    }

    Expression getAdditional(Session session2, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null && expression.isConstant()) {
            this.valueList.add(expression);
            this.valueSet.add(expression.getValue(session2).convertTo(this.left.getType()));
            return this;
        }
        return null;
    }
}

