/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.AggregateDataGroupConcat;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Aggregate
extends Expression {
    public static final int COUNT_ALL = 0;
    public static final int COUNT = 1;
    public static final int GROUP_CONCAT = 2;
    static final int SUM = 3;
    static final int MIN = 4;
    static final int MAX = 5;
    static final int AVG = 6;
    static final int STDDEV_POP = 7;
    static final int STDDEV_SAMP = 8;
    static final int VAR_POP = 9;
    static final int VAR_SAMP = 10;
    static final int BOOL_OR = 11;
    static final int BOOL_AND = 12;
    static final int BIT_OR = 13;
    static final int BIT_AND = 14;
    static final int SELECTIVITY = 15;
    static final int HISTOGRAM = 16;
    private static final HashMap<String, Integer> AGGREGATES = New.hashMap();
    private final int type;
    private final Select select;
    private final boolean distinct;
    private Expression on;
    private Expression groupConcatSeparator;
    private ArrayList<SelectOrderBy> groupConcatOrderList;
    private SortOrder groupConcatSort;
    private int dataType;
    private int scale;
    private long precision;
    private int displaySize;
    private int lastGroupRowId;

    public Aggregate(int n, Expression expression, Select select, boolean bl) {
        this.type = n;
        this.on = expression;
        this.select = select;
        this.distinct = bl;
    }

    private static void addAggregate(String string, int n) {
        AGGREGATES.put(string, n);
    }

    public static int getAggregateType(String string) {
        Integer n = AGGREGATES.get(string);
        return n == null ? -1 : n;
    }

    public void setGroupConcatOrder(ArrayList<SelectOrderBy> arrayList) {
        this.groupConcatOrderList = arrayList;
    }

    public void setGroupConcatSeparator(Expression expression) {
        this.groupConcatSeparator = expression;
    }

    private SortOrder initOrder(Session session2) {
        int n = this.groupConcatOrderList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            SelectOrderBy selectOrderBy = this.groupConcatOrderList.get(i);
            nArray[i] = i + 1;
            nArray2[i] = n2 = selectOrderBy.descending ? 1 : 0;
        }
        return new SortOrder(session2.getDatabase(), nArray, nArray2, null);
    }

    @Override
    public void updateAggregate(Session session2) {
        Value value;
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == n) {
            return;
        }
        this.lastGroupRowId = n;
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = AggregateData.create(this.type);
            hashMap.put(this, aggregateData);
        }
        Value value2 = value = this.on == null ? null : this.on.getValue(session2);
        if (this.type == 2 && value != ValueNull.INSTANCE) {
            value = value.convertTo(13);
            if (this.groupConcatOrderList != null) {
                int n2 = this.groupConcatOrderList.size();
                Value[] valueArray = new Value[1 + n2];
                valueArray[0] = value;
                for (int i = 0; i < n2; ++i) {
                    SelectOrderBy selectOrderBy = this.groupConcatOrderList.get(i);
                    valueArray[i + 1] = selectOrderBy.expression.getValue(session2);
                }
                value = ValueArray.get(valueArray);
            }
        }
        aggregateData.add(session2.getDatabase(), this.dataType, this.distinct, value);
    }

    @Override
    public Value getValue(Session session2) {
        HashMap<Expression, Object> hashMap;
        if (this.select.isQuickAggregateQuery()) {
            switch (this.type) {
                case 0: 
                case 1: {
                    Table table = this.select.getTopTableFilter().getTable();
                    return ValueLong.get(table.getRowCount(session2));
                }
                case 4: 
                case 5: {
                    Cursor cursor;
                    SearchRow searchRow;
                    boolean bl = this.type == 4;
                    Index index = this.getColumnIndex();
                    int n = index.getIndexColumns()[0].sortType;
                    if ((n & 1) != 0) {
                        bl = !bl;
                    }
                    Value value = (searchRow = (cursor = index.findFirstOrLast(session2, bl)).getSearchRow()) == null ? ValueNull.INSTANCE : searchRow.getValue(index.getColumns()[0].getColumnId());
                    return value;
                }
            }
            DbException.throwInternalError("type=" + this.type);
        }
        if ((hashMap = this.select.getCurrentGroup()) == null) {
            throw DbException.get(90054, this.getSQL());
        }
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = AggregateData.create(this.type);
        }
        Value value = aggregateData.getValue(session2.getDatabase(), this.dataType, this.distinct);
        if (this.type == 2) {
            Object object;
            ArrayList<Value> arrayList = ((AggregateDataGroupConcat)aggregateData).getList();
            if (arrayList == null || arrayList.size() == 0) {
                return ValueNull.INSTANCE;
            }
            if (this.groupConcatOrderList != null) {
                object = this.groupConcatSort;
                Collections.sort(arrayList, new Comparator<Value>((SortOrder)object){
                    final /* synthetic */ SortOrder val$sortOrder;
                    {
                        this.val$sortOrder = sortOrder;
                    }

                    @Override
                    public int compare(Value value, Value value2) {
                        Value[] valueArray = ((ValueArray)value).getList();
                        Value[] valueArray2 = ((ValueArray)value2).getList();
                        return this.val$sortOrder.compare(valueArray, valueArray2);
                    }
                });
            }
            object = new StatementBuilder();
            String string = this.groupConcatSeparator == null ? "," : this.groupConcatSeparator.getValue(session2).getString();
            for (Value value2 : arrayList) {
                String string2 = value2.getType() == 17 ? ((ValueArray)value2).getList()[0].getString() : value2.getString();
                if (string2 == null) continue;
                if (string != null) {
                    ((StatementBuilder)object).appendExceptFirst(string);
                }
                ((StatementBuilder)object).append(string2);
            }
            value = ValueString.get(((StatementBuilder)object).toString());
        }
        return value;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        if (this.on != null) {
            this.on.mapColumns(columnResolver, n);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression.mapColumns(columnResolver, n);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session2) {
        if (this.on != null) {
            this.on = this.on.optimize(session2);
            this.dataType = this.on.getType();
            this.scale = this.on.getScale();
            this.precision = this.on.getPrecision();
            this.displaySize = this.on.getDisplaySize();
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session2);
            }
            this.groupConcatSort = this.initOrder(session2);
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator = this.groupConcatSeparator.optimize(session2);
        }
        switch (this.type) {
            case 2: {
                this.dataType = 13;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case 0: 
            case 1: {
                this.dataType = 5;
                this.scale = 0;
                this.precision = 19L;
                this.displaySize = 20;
                break;
            }
            case 15: {
                this.dataType = 4;
                this.scale = 0;
                this.precision = 10L;
                this.displaySize = 11;
                break;
            }
            case 16: {
                this.dataType = 17;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                if (this.dataType == 1) {
                    this.dataType = 5;
                    break;
                }
                if (!DataType.supportsAdd(this.dataType)) {
                    throw DbException.get(90015, this.getSQL());
                }
                this.dataType = DataType.getAddProofType(this.dataType);
                break;
            }
            case 6: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case 4: 
            case 5: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.dataType = 7;
                this.precision = 17L;
                this.displaySize = 24;
                this.scale = 0;
                break;
            }
            case 11: 
            case 12: {
                this.dataType = 1;
                this.precision = 1L;
                this.displaySize = 5;
                this.scale = 0;
                break;
            }
            case 13: 
            case 14: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.on != null) {
            this.on.setEvaluatable(tableFilter, bl);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        return this.displaySize;
    }

    private String getSQLGroupConcat() {
        StatementBuilder statementBuilder = new StatementBuilder("GROUP_CONCAT(");
        if (this.distinct) {
            statementBuilder.append("DISTINCT ");
        }
        statementBuilder.append(this.on.getSQL());
        if (this.groupConcatOrderList != null) {
            statementBuilder.append(" ORDER BY ");
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(selectOrderBy.expression.getSQL());
                if (!selectOrderBy.descending) continue;
                statementBuilder.append(" DESC");
            }
        }
        if (this.groupConcatSeparator != null) {
            statementBuilder.append(" SEPARATOR ").append(this.groupConcatSeparator.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getSQL() {
        String string;
        switch (this.type) {
            case 2: {
                return this.getSQLGroupConcat();
            }
            case 0: {
                return "COUNT(*)";
            }
            case 1: {
                string = "COUNT";
                break;
            }
            case 15: {
                string = "SELECTIVITY";
                break;
            }
            case 16: {
                string = "HISTOGRAM";
                break;
            }
            case 3: {
                string = "SUM";
                break;
            }
            case 4: {
                string = "MIN";
                break;
            }
            case 5: {
                string = "MAX";
                break;
            }
            case 6: {
                string = "AVG";
                break;
            }
            case 7: {
                string = "STDDEV_POP";
                break;
            }
            case 8: {
                string = "STDDEV_SAMP";
                break;
            }
            case 9: {
                string = "VAR_POP";
                break;
            }
            case 10: {
                string = "VAR_SAMP";
                break;
            }
            case 12: {
                string = "BOOL_AND";
                break;
            }
            case 11: {
                string = "BOOL_OR";
                break;
            }
            case 14: {
                string = "BIT_AND";
                break;
            }
            case 13: {
                string = "BIT_OR";
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        if (this.distinct) {
            return string + "(DISTINCT " + this.on.getSQL() + ")";
        }
        return string + StringUtils.enclose(this.on.getSQL());
    }

    private Index getColumnIndex() {
        if (this.on instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)this.on;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                Index index = table.getIndexForColumn(column);
                return index;
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 1) {
            switch (this.type) {
                case 1: {
                    if (!this.distinct && this.on.getNullable() == 0) {
                        return expressionVisitor.getTable().canGetRowCount();
                    }
                    return false;
                }
                case 0: {
                    return expressionVisitor.getTable().canGetRowCount();
                }
                case 4: 
                case 5: {
                    Index index = this.getColumnIndex();
                    return index != null;
                }
            }
            return false;
        }
        if (this.on != null && !this.on.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.groupConcatSeparator != null && !this.groupConcatSeparator.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.groupConcatOrderList != null) {
            int n = this.groupConcatOrderList.size();
            for (int i = 0; i < n; ++i) {
                SelectOrderBy selectOrderBy = this.groupConcatOrderList.get(i);
                if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        return this.on == null ? 1 : this.on.getCost() + 1;
    }

    static {
        Aggregate.addAggregate("COUNT", 1);
        Aggregate.addAggregate("SUM", 3);
        Aggregate.addAggregate("MIN", 4);
        Aggregate.addAggregate("MAX", 5);
        Aggregate.addAggregate("AVG", 6);
        Aggregate.addAggregate("GROUP_CONCAT", 2);
        Aggregate.addAggregate("STRING_AGG", 2);
        Aggregate.addAggregate("STDDEV_SAMP", 8);
        Aggregate.addAggregate("STDDEV", 8);
        Aggregate.addAggregate("STDDEV_POP", 7);
        Aggregate.addAggregate("STDDEVP", 7);
        Aggregate.addAggregate("VAR_POP", 9);
        Aggregate.addAggregate("VARP", 9);
        Aggregate.addAggregate("VAR_SAMP", 10);
        Aggregate.addAggregate("VAR", 10);
        Aggregate.addAggregate("VARIANCE", 10);
        Aggregate.addAggregate("BOOL_OR", 11);
        Aggregate.addAggregate("SOME", 11);
        Aggregate.addAggregate("BOOL_AND", 12);
        Aggregate.addAggregate("EVERY", 12);
        Aggregate.addAggregate("SELECTIVITY", 15);
        Aggregate.addAggregate("HISTOGRAM", 16);
        Aggregate.addAggregate("BIT_OR", 13);
        Aggregate.addAggregate("BIT_AND", 14);
    }
}

