/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class Analyze
extends DefineCommand {
    private int sampleRows;

    public Analyze(Session session2) {
        super(session2);
        this.sampleRows = session2.getDatabase().getSettings().analyzeSample;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        for (Table table : database.getAllTablesAndViews(false)) {
            Analyze.analyzeTable(this.session, table, this.sampleRows, true);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeTable(Session session2, Table table, int n, boolean bl) {
        if (!table.getTableType().equals("TABLE") || table.isHidden() || session2 == null) {
            return;
        }
        if (!bl) {
            if (session2.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session2.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session2)) {
            return;
        }
        if (!session2.getUser().hasRight(table, 1)) {
            return;
        }
        if (session2.getCancel() != 0L) {
            return;
        }
        Column[] columnArray = table.getColumns();
        if (columnArray.length == 0) {
            return;
        }
        Database database = session2.getDatabase();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        for (Column i : columnArray) {
            statementBuilder.appendExceptFirst(", ");
            int value = i.getType();
            if (value == 15 || value == 16) {
                statementBuilder.append("MAX(NULL)");
                continue;
            }
            statementBuilder.append("SELECTIVITY(").append(i.getSQL()).append(')');
        }
        statementBuilder.append(" FROM ").append(table.getSQL());
        if (n > 0) {
            statementBuilder.append(" LIMIT ? SAMPLE_SIZE ? ");
        }
        String string = statementBuilder.toString();
        Prepared prepared = session2.prepare(string);
        if (n > 0) {
            ArrayList<Parameter> resultInterface = prepared.getParameters();
            resultInterface.get(0).setValue(ValueInt.get(1));
            resultInterface.get(1).setValue(ValueInt.get(n));
        }
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        for (int session3 = 0; session3 < columnArray.length; ++session3) {
            Value session4 = resultInterface.currentRow()[session3];
            if (session4 == ValueNull.INSTANCE) continue;
            int database2 = session4.getInt();
            columnArray[session3].setSelectivity(database2);
        }
        if (bl) {
            database.updateMeta(session2, table);
        } else {
            Session session3 = database.getSystemSession();
            if (session3 != session2) {
                Session session4 = session3;
                synchronized (session4) {
                    Database database2 = database;
                    synchronized (database2) {
                        database.updateMeta(session3, table);
                        session3.commit(true);
                    }
                }
            }
        }
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }
}

