/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    public static final char QUOTE_CHAR = '\"';
    private final boolean returnSeparators;
    private final String text;
    private final int maxIndex;
    private String separators;
    private int index;

    public QuotedStringTokenizer(String text, String separators, boolean returnSeparators) {
        this.text = text;
        this.maxIndex = text.length() - 1;
        this.separators = separators;
        this.returnSeparators = returnSeparators;
    }

    public QuotedStringTokenizer(String text, String separators) {
        this(text, separators, false);
    }

    public QuotedStringTokenizer(String text) {
        this(text, " ", false);
    }

    public int countTokens() {
        Token token;
        int count = 0;
        int i = this.index;
        while ((token = this.nextToken(i)) != null) {
            ++count;
            i = token.nextIndex;
        }
        return count;
    }

    public boolean hasMoreTokens() {
        return this.nextToken(this.index) != null;
    }

    public String nextToken(String separators) {
        this.separators = separators;
        return this.nextToken();
    }

    public String nextToken() {
        Token token = this.nextToken(this.index);
        if (token != null) {
            this.index = token.nextIndex;
            return token.text;
        }
        throw new NoSuchElementException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token nextToken(int index) {
        int i;
        if (index > this.maxIndex) {
            return null;
        }
        if (this.returnSeparators && this.separators.indexOf(this.text.charAt(index)) != -1) {
            return new Token(this.text.substring(index, index + 1), index + 1);
        }
        boolean inQuotes = false;
        StringBuilder token = new StringBuilder();
        for (i = index; i <= this.maxIndex && this.separators.indexOf(this.text.charAt(i)) != -1; ++i) {
        }
        if (i > this.maxIndex) {
            return null;
        }
        while (i <= this.maxIndex) {
            char c = this.text.charAt(i);
            if (this.separators.indexOf(c) != -1) {
                if (!inQuotes) return new Token(token.toString(), i);
                token.append(c);
            } else if (c == '\"') {
                inQuotes = !inQuotes;
            } else {
                token.append(c);
            }
            ++i;
        }
        return new Token(token.toString(), i);
    }

    private class Token {
        String text;
        int nextIndex;

        Token(String text, int nextIndex) {
            this.text = text;
            this.nextIndex = nextIndex;
        }
    }
}

