/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import org.limewire.setting.FileSetSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.util.CommonUtils;

public class LibrarySettings
extends LimeProps {
    private static final File PORTABLE_ROOT_FOLDER = CommonUtils.getPortableRootFolder();
    public static final File LIBRARY_DATABASE = new File(CommonUtils.getUserSettingsDir(), "library_db");
    public static final FileSetSetting DIRECTORIES_TO_INCLUDE = FACTORY.createFileSetSetting("DIRECTORIES_TO_INCLUDE_FOR_FILES", new File[0]);
    public static final FileSetSetting DIRECTORIES_NOT_TO_INCLUDE = FACTORY.createFileSetSetting("DIRECTORIES_NOT_TO_INCLUDE", new File[0]);
    public static final FileSetSetting DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4 = FACTORY.createFileSetSetting("DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4", new File[0]);
    public static final FileSetting USER_MUSIC_FOLDER = FACTORY.createFileSetting("USER_MUSIC_FOLDER", FrostWireUtils.getUserMusicFolder());
    public static final FileSetting USER_VIDEO_FOLDER = FACTORY.createFileSetting("USER_VIDEO_FOLDER", FrostWireUtils.getUserVideoFolder());
    public static final IntSetting LAST_SELECTED_LIBRARY_DIRECTORY_HOLDER_OFFSET = FACTORY.createIntSetting("LAST_SELECTED_LIBRARY_DIRECTORY_HOLDER_OFFSET", -1);

    private LibrarySettings() {
    }

    public static void setupInitialLibraryFolders() {
        SharingSettings.initTorrentDataDirSetting();
        DIRECTORIES_TO_INCLUDE.add(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
        for (File f : FrostWireUtils.getFrostWire4SaveDirectories()) {
            DIRECTORIES_TO_INCLUDE.add(f);
            DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4.add(f);
        }
        if (PORTABLE_ROOT_FOLDER == null) {
            if (USER_MUSIC_FOLDER.getValue().exists()) {
                DIRECTORIES_TO_INCLUDE.add(USER_MUSIC_FOLDER.getValue());
            }
            if (USER_VIDEO_FOLDER.getValue().exists()) {
                DIRECTORIES_TO_INCLUDE.add(USER_VIDEO_FOLDER.getValue());
            }
        }
    }

    public static void resetLibraryFoldersIfPortable() {
        if (CommonUtils.isPortable()) {
            DIRECTORIES_TO_INCLUDE.removeAll();
            LibrarySettings.setupInitialLibraryFolders();
        }
    }
}

