/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import java.io.File;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class ApplicationSettings
extends LimeProps {
    public static final BooleanSetting INSTALLED = FACTORY.createBooleanSetting("INSTALLED", false);
    public static final IntSetting APP_WIDTH = FACTORY.createIntSetting("APP_WIDTH", 1024);
    public static final IntSetting APP_HEIGHT = FACTORY.createIntSetting("APP_HEIGHT", 600);
    public static final BooleanSetting RUN_ONCE = FACTORY.createBooleanSetting("RUN_ONCE", false);
    public static final IntSetting WINDOW_X = (IntSetting)FACTORY.createIntSetting("WINDOW_X", 0).setAlwaysSave(true);
    public static final IntSetting WINDOW_Y = (IntSetting)FACTORY.createIntSetting("WINDOW_Y", 0).setAlwaysSave(true);
    public static final BooleanSetting MAXIMIZE_WINDOW = FACTORY.createBooleanSetting("MAXIMIZE_WINDOW", false);
    public static final BooleanSetting DISPLAY_TRAY_ICON = FACTORY.createBooleanSetting("DISPLAY_TRAY_ICON", true);
    public static final StringSetting LANGUAGE = FACTORY.createStringSetting("LANGUAGE", System.getProperty("user.language", ""));
    public static final StringSetting COUNTRY = FACTORY.createStringSetting("COUNTRY", System.getProperty("user.country", ""));
    public static final StringSetting LOCALE_VARIANT = FACTORY.createStringSetting("LOCALE_VARIANT", System.getProperty("user.variant", ""));
    public static final BooleanSetting AUTOMATIC_MANUAL_GC = FACTORY.createBooleanSetting("AUTOMATIC_MANUAL_GC", OSUtils.isMacOSX());
    public static final BooleanSetting MAGNET_CLIPBOARD_LISTENER = FACTORY.createBooleanSetting("MAGNET_CLIPBOARD_LISTENER", !OSUtils.isWindows() && !OSUtils.isAnyMac());
    public static final BooleanSetting HANDLE_MAGNETS = FACTORY.createBooleanSetting("HANDLE_MAGNETS", true);
    public static final BooleanSetting HANDLE_TORRENTS = FACTORY.createBooleanSetting("HANDLE_TORRENTS", true);
    public static final FileSetting LAST_FILECHOOSER_DIRECTORY = FACTORY.createFileSetting("LAST_FILECHOOSER_DIR", new File("")).setAlwaysSave(true);
    public static final IntSetting FILECHOOSER_WIDTH = (IntSetting)FACTORY.createIntSetting("FILECHOOSER_WIDTH", 900).setAlwaysSave(true);
    public static final IntSetting FILECHOOSER_HEIGHT = (IntSetting)FACTORY.createIntSetting("FILECHOOSER_HEIGHT", 700).setAlwaysSave(true);
    public static final IntSetting FILECHOOSER_X_POS = (IntSetting)FACTORY.createIntSetting("FILECHOOSER_X_POS", -1).setAlwaysSave(true);
    public static final IntSetting FILECHOOSER_Y_POS = (IntSetting)FACTORY.createIntSetting("FILECHOOSER_Y_POS", -1).setAlwaysSave(true);
    public static final BooleanSetting MINIMIZE_TO_TRAY = FACTORY.createBooleanSetting("MINIMIZE_TO_TRAY", OSUtils.supportsTray());
    public static final BooleanSetting SHOW_HIDE_EXIT_DIALOG = FACTORY.createBooleanSetting("SHOW_HIDE_EXIT_DIALOG", true);
    public static final FileSetting APP_DATABASES_PATH = FACTORY.createFileSetting("APP_DATABASES_PATH", new File(CommonUtils.getUserSettingsDir(), "dbs"));
    public static final IntSetting GUI_TABLES_FONT_SIZE = (IntSetting)FACTORY.createIntSetting("GUI_TABLES_FONT_SIZE", 0).setAlwaysSave(true);
    public static final BooleanSetting UX_STATS_ENABLED = FACTORY.createBooleanSetting("UX_STATS_ENABLED", true);
    public static final StringSetting OPTIONS_LAST_SELECTED_KEY = FACTORY.createStringSetting("OPTIONS_LAST_SELECTED_KEY", "OPTIONS_BITTORRENT_BASIC_TITLE");

    private ApplicationSettings() {
    }

    public static String getLanguage() {
        String lc = LANGUAGE.getValue();
        String cc = COUNTRY.getValue();
        String lv = LOCALE_VARIANT.getValue();
        String lang = lc;
        if (cc != null && !cc.equals("")) {
            lang = lang + "_" + cc;
        }
        if (lv != null && !lv.equals("")) {
            lang = lang + "_" + lv;
        }
        return lang;
    }
}

