/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.collection.CharSequenceKeyAnalyzer;
import org.limewire.collection.PatriciaTrie;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

public class FilteredTreeModel
implements TreeModel {
    private boolean ignoreCase;
    private FilteredTreeModelListener listener;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private TreeModel model;
    private ParentProvider parentProvider;
    private PatriciaTrie<String, List<Object>> searchTrie = new PatriciaTrie(new CharSequenceKeyAnalyzer());
    private Set<Object> visibleNodes;

    public FilteredTreeModel(DefaultTreeModel model, boolean ignoreCase) {
        this(model, ignoreCase, new TreeNodeParentProvider());
    }

    public FilteredTreeModel(TreeModel model, boolean ignoreCase, ParentProvider parentProvider) {
        this.ignoreCase = ignoreCase;
        this.listener = new FilteredTreeModelListener();
        this.setModel(model, parentProvider);
    }

    public void addSearchKey(Object node, String key) {
        List<Object> value = this.searchTrie.get(key = this.normalize(key));
        if (value == null) {
            value = new ArrayList<Object>(1);
            this.searchTrie.put(key, value);
        }
        value.add(node);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void clearFilter() {
        this.filterByText(null);
    }

    public void filterByText(String text) {
        if ((text = this.normalize(text)) == null || text.length() == 0) {
            this.visibleNodes = null;
        } else {
            this.visibleNodes = new HashSet<Object>();
            String[] keywords = StringUtils.split(I18NConvert.instance().getNorm(text), " ");
            for (int i = 0; i < keywords.length; ++i) {
                SortedMap<String, List<Object>> nodeListByKey = this.searchTrie.getPrefixedBy(keywords[i]);
                if (i == 0) {
                    for (List<Object> nodes : nodeListByKey.values()) {
                        this.visibleNodes.addAll(nodes);
                    }
                    continue;
                }
                HashSet<Object> allNew = new HashSet<Object>();
                for (List<Object> nodes : nodeListByKey.values()) {
                    allNew.addAll(nodes);
                }
                this.visibleNodes.retainAll(allNew);
            }
            this.ensureParentsVisible();
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.visibleNodes == null) {
            return this.model.getChild(parent, index);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            Object node = this.model.getChild(parent, i);
            if (!this.visibleNodes.contains(node) || index != visibleIndex++) continue;
            return node;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.visibleNodes == null) {
            return this.model.getChildCount(parent);
        }
        int visibleCount = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            if (!this.visibleNodes.contains(this.model.getChild(parent, i))) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.visibleNodes == null) {
            return this.model.getIndexOfChild(parent, child);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            Object node = this.model.getChild(parent, i);
            if (!this.visibleNodes.contains(node)) continue;
            if (node == child) {
                return visibleIndex;
            }
            ++visibleIndex;
        }
        return -1;
    }

    public TreeModel getModel() {
        return this.model;
    }

    @Override
    public Object getRoot() {
        return this.model.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    public boolean isVisible(Object node) {
        return this.visibleNodes == null || this.visibleNodes.contains(node);
    }

    private String normalize(String text) {
        if (text != null && this.ignoreCase) {
            text = text.toLowerCase();
        }
        return text;
    }

    public void reload() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    public void removeSearchKey(Object node, String key) {
        List<Object> value = this.searchTrie.get(key = this.normalize(key));
        if (value != null) {
            value.remove(node);
            if (value.isEmpty()) {
                this.searchTrie.remove(key);
            }
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void setModel(DefaultTreeModel model) {
        this.setModel(model, new TreeNodeParentProvider());
    }

    public void setModel(TreeModel model, ParentProvider parentProvider) {
        if (model == null || parentProvider == null) {
            throw new IllegalArgumentException();
        }
        if (this.model != null) {
            this.model.removeTreeModelListener(this.listener);
        }
        this.model = model;
        this.parentProvider = parentProvider;
        this.model.addTreeModelListener(this.listener);
        this.searchTrie.clear();
        this.reset();
    }

    public void reset() {
        this.visibleNodes = null;
        this.reload();
    }

    private void ensureParentsVisible() {
        HashSet<Object> parentNodes = new HashSet<Object>();
        for (Object node : this.visibleNodes) {
            Object parentNode = this.parentProvider.getParent(node);
            while (parentNode != null) {
                parentNodes.add(parentNode);
                parentNode = this.parentProvider.getParent(parentNode);
            }
        }
        this.visibleNodes.addAll(parentNodes);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    public static interface ParentProvider {
        public Object getParent(Object var1);
    }

    public static class TreeNodeParentProvider
    implements ParentProvider {
        @Override
        public Object getParent(Object node) {
            return ((TreeNode)node).getParent();
        }
    }

    private class FilteredTreeModelListener
    implements TreeModelListener {
        private FilteredTreeModelListener() {
        }

        public TreeModelEvent refactorEvent(TreeModelEvent event) {
            if (FilteredTreeModel.this.visibleNodes != null) {
                ArrayList<Object> children = new ArrayList<Object>(event.getChildren().length);
                ArrayList<Integer> indicieList = new ArrayList<Integer>(event.getChildIndices().length);
                for (Object node : event.getChildren()) {
                    FilteredTreeModel.this.visibleNodes.add(node);
                }
                Object parent = event.getTreePath().getLastPathComponent();
                for (Object node : event.getChildren()) {
                    children.add(node);
                    indicieList.add(FilteredTreeModel.this.getIndexOfChild(parent, node));
                }
                int[] indicies = new int[indicieList.size()];
                for (int i = 0; i < indicies.length; ++i) {
                    indicies[i] = (Integer)indicieList.get(i);
                }
                event = new TreeModelEvent(event.getSource(), event.getTreePath(), indicies, children.toArray(new Object[0]));
            }
            return event;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesChanged(event);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }
}

