/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class KeyTypedMover
implements KeyListener {
    private String prefix = "";
    private String typedString = "";
    private long lastTime = 0L;
    private final long timeFactor = 500L;

    @Override
    public void keyTyped(KeyEvent e) {
        int index;
        LimeJTable src = (LimeJTable)e.getSource();
        TableModel model = src.getModel();
        if (model.getRowCount() == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown() || this.isNavigationKey(e)) {
            return;
        }
        boolean startingFromSelection = true;
        char c = e.getKeyChar();
        long time = e.getWhen();
        int startIndex = src.getSelectionModel().getLeadSelectionIndex();
        if (time - this.lastTime < 500L) {
            this.typedString = this.typedString + c;
            if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                ++startIndex;
            } else {
                this.prefix = this.typedString;
            }
        } else {
            ++startIndex;
            this.prefix = this.typedString = "" + c;
        }
        this.lastTime = time;
        if (startIndex < 0 || startIndex >= model.getRowCount()) {
            startingFromSelection = false;
            startIndex = 0;
        }
        if ((index = src.getNextMatch(this.prefix, startIndex, Position.Bias.Forward)) >= 0) {
            src.setSelectedRow(index);
            src.ensureRowVisible(index);
        } else if (startingFromSelection && (index = src.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
            src.setSelectedRow(index);
            src.ensureRowVisible(index);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isNavigationKey(e)) {
            this.prefix = "";
            this.typedString = "";
            this.lastTime = 0L;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private boolean isNavigationKey(KeyEvent event) {
        InputMap inputMap = ((JComponent)event.getSource()).getInputMap(1);
        KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
        return inputMap != null && inputMap.get(key) != null;
    }
}

