/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;

public final class HeaderMouseListener
implements MouseInputListener {
    private HeaderMouseObserver hmo;
    private boolean isResizing = false;

    public HeaderMouseListener(HeaderMouseObserver hmo) {
        this.hmo = hmo;
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (!this.tryPopup(ev) && SwingUtilities.isLeftMouseButton(ev)) {
            if (!this.isResizing) {
                this.hmo.handleHeaderColumnLeftClick(ev.getPoint());
            } else {
                this.isResizing = false;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (!this.tryPopup(ev) && SwingUtilities.isLeftMouseButton(ev)) {
            if (((JTableHeader)ev.getSource()).getResizingColumn() == null) {
                this.hmo.handleHeaderColumnPressed(ev.getPoint());
            } else {
                this.isResizing = true;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.tryPopup(ev) && SwingUtilities.isLeftMouseButton(ev)) {
            this.hmo.handleHeaderColumnReleased(ev.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.isResizing = false;
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }

    private boolean tryPopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.hmo.handleHeaderPopupMenu(ev.getPoint());
            return true;
        }
        return false;
    }
}

