/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.bittorrent.PaymentOptionsRenderer;
import com.frostwire.gui.bittorrent.TransferActionsRenderer;
import com.frostwire.gui.bittorrent.TransferDetailFilesActionsRenderer;
import com.frostwire.gui.bittorrent.TransferSeedingRenderer;
import com.frostwire.gui.components.transfers.TransferDetailFiles;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.search.SearchResultActionsHolder;
import com.limegroup.gnutella.gui.search.SearchResultActionsRenderer;
import com.limegroup.gnutella.gui.search.SourceHolder;
import com.limegroup.gnutella.gui.search.SourceRenderer;
import com.limegroup.gnutella.gui.tables.AbstractActionsHolder;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameHolder;
import com.limegroup.gnutella.gui.tables.ActionIconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.CenteredHolder;
import com.limegroup.gnutella.gui.tables.CenteredRenderer;
import com.limegroup.gnutella.gui.tables.ColorRenderer;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.DateRenderer;
import com.limegroup.gnutella.gui.tables.DefaultColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.DefaultTableBevelledCellRenderer;
import com.limegroup.gnutella.gui.tables.FlexibleColumnResizeAdapter;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.IconRenderer;
import com.limegroup.gnutella.gui.tables.KeyTypedMover;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.NameHolder;
import com.limegroup.gnutella.gui.tables.NameHolderRenderer;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.RemoveListener;
import com.limegroup.gnutella.gui.tables.SelectionListener;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TableSettings;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.limewire.util.StringUtils;

public abstract class AbstractTableMediator<T extends DataLineModel<E, I>, E extends DataLine<I>, I>
implements ComponentMediator<I>,
HeaderMouseObserver {
    protected final String ID;
    protected PaddedPanel MAIN_PANEL;
    protected T DATA_MODEL;
    protected LimeJTable TABLE;
    protected ButtonRow BUTTON_ROW;
    public ActionListener REMOVE_LISTENER;
    public MouseListener DEFAULT_LISTENER;
    public MouseInputListener HEADER_LISTENER;
    public ListSelectionListener SELECTION_LISTENER;
    public KeyListener AUTO_NAVIGATION_KEY_LISTENER;
    public TableSettings SETTINGS;
    private static TableCellRenderer SPEED_RENDERER;
    private static TableCellRenderer PROGRESS_BAR_RENDERER;
    private static TableCellRenderer COLOR_RENDERER;
    private static TableCellRenderer ICON_RENDERER;
    private static TableCellRenderer ICON_AND_NAME_RENDERER;
    private static TableCellRenderer ACTION_ICON_AND_NAME_RENDERER;
    private static SourceRenderer SOURCE_RENDERER;
    private static SearchResultActionsRenderer SEARCH_RESULT_ACTIONS_RENDERER;
    private static TableCellRenderer DEFAULT_RENDERER;
    private static TableCellRenderer CENTER_RENDERER;
    private static TableCellRenderer DATE_RENDERER;
    private static NameHolderRenderer NAME_HOLDER_RENDERER;
    private static TransferActionsRenderer TRANSFER_ACTIONS_RENDERER;
    private static TransferSeedingRenderer TRANSFER_SEEDING_RENDERER;
    private static PaymentOptionsRenderer PAYMENT_OPTIONS_RENDERER;
    private static TransferDetailFilesActionsRenderer TRANSFER_DETAIL_FILE_ACTIONS_RENDERER;
    protected Resorter RESORTER = new Resorter();
    protected JComponent TABLE_PANE;
    protected JScrollPane SCROLL_PANE;
    protected boolean isResorting = false;

    protected AbstractTableMediator(String id) {
        this.ID = id;
        this.updateSplashScreen();
        this.buildSettings();
        this.buildListeners();
        this.setupConstants();
        assert (this.DATA_MODEL != null) : "DATA_MODEL not set.";
        assert (this.TABLE != null) : "TABLE not set.";
        this.setupTable();
        this.setupDragAndDrop();
        this.addActions();
        this.addListeners();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setupMainPanel();
        this.setupTableHeaders();
        this.handleNoSelection();
    }

    protected void setupDragAndDrop() {
    }

    protected abstract void updateSplashScreen();

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID);
    }

    protected abstract void setupConstants();

    protected void buildListeners() {
        this.DEFAULT_LISTENER = new DefaultMouseListener(this);
        this.SELECTION_LISTENER = new SelectionListener(this);
        this.HEADER_LISTENER = new HeaderMouseListener(this);
        this.REMOVE_LISTENER = new RemoveListener(this);
        this.AUTO_NAVIGATION_KEY_LISTENER = new KeyTypedMover();
    }

    protected void addListeners() {
        this.TABLE.addMouseListener(this.DEFAULT_LISTENER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.SELECTION_LISTENER);
        this.TABLE.getTableHeader().addMouseListener(this.HEADER_LISTENER);
        this.TABLE.getTableHeader().addMouseMotionListener(this.HEADER_LISTENER);
        this.TABLE.addKeyListener(this.AUTO_NAVIGATION_KEY_LISTENER);
    }

    protected void setupTable() {
        this.TABLE.setRowHeight(this.TABLE.getRowHeight() + 1);
        this.TABLE.setShowGrid(false);
        this.TABLE.setColumnSelectionAllowed(false);
        this.TABLE.setTableSettings(this.SETTINGS);
        this.TABLE.getTableHeader().addMouseListener(new FlexibleColumnResizeAdapter());
    }

    protected void addActions() {
        InputMap map = this.TABLE.getInputMap(1);
        AbstractAction enter = new AbstractAction(){
            private static final long serialVersionUID = 5177362850526818763L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTableMediator.this.handleActionKey();
            }
        };
        this.installAction(map, enter, 10, "limewire.action");
        AbstractAction delete = new AbstractAction(){
            private static final long serialVersionUID = 6973509148820061808L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AbstractTableMediator.this.TABLE.isEditing()) {
                    AbstractTableMediator.this.removeSelection();
                }
            }
        };
        this.installAction(map, delete, 8, "limewire.delete");
        this.installAction(map, delete, 127, "limewire.delete");
    }

    private void installAction(InputMap map, Action action, int key, String sig) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key, 0);
        Object obj = map.get(stroke);
        if (obj != null) {
            this.TABLE.getActionMap().put(obj, action);
        } else {
            map.put(stroke, sig);
            this.TABLE.getActionMap().put(sig, action);
        }
    }

    protected void setDefaultRenderers() {
        this.TABLE.setDefaultRenderer(ProgressBarHolder.class, this.getProgressBarRenderer());
        this.TABLE.setDefaultRenderer(ColoredCell.class, this.getColorRenderer());
        this.TABLE.setDefaultRenderer(Icon.class, this.getIconRenderer());
        this.TABLE.setDefaultRenderer(IconAndNameHolder.class, this.getIconAndNameRenderer());
        this.TABLE.setDefaultRenderer(ActionIconAndNameHolder.class, this.getActionIconAndNameRenderer());
        this.TABLE.setDefaultRenderer(SearchResultActionsHolder.class, this.getSearchResultsActionsRenderer());
        this.TABLE.setDefaultRenderer(SourceHolder.class, this.getSourceRenderer());
        this.TABLE.setDefaultRenderer(Object.class, this.getDefaultRenderer());
        this.TABLE.setDefaultRenderer(CenteredHolder.class, this.getCenterRenderer());
        this.TABLE.setDefaultRenderer(SpeedRenderer.class, this.getSpeedRenderer());
        this.TABLE.setDefaultRenderer(Date.class, this.getDateRenderer());
        this.TABLE.setDefaultRenderer(NameHolder.class, this.getNameHolderRenderer());
        this.TABLE.setDefaultRenderer(TransferDetailFiles.TransferItemHolder.class, this.getTransferDetailFileActionsRenderer());
        if (this.getAbstractActionsRenderer() != null) {
            this.TABLE.setDefaultRenderer(AbstractActionsHolder.class, this.getAbstractActionsRenderer());
        }
    }

    protected TableCellRenderer getAbstractActionsRenderer() {
        return null;
    }

    protected void setDefaultEditors() {
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            if (this.BUTTON_ROW != null) {
                this.MAIN_PANEL.add(Box.createVerticalStrut(6));
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
        }
    }

    private void setupTableHeaders() {
        ColumnPreferenceHandler cph = this.createDefaultColumnPreferencesHandler();
        cph.setWidths();
        cph.setOrder();
        cph.setVisibility();
        this.TABLE.setColumnPreferenceHandler(cph);
    }

    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new DefaultColumnPreferenceHandler(this.TABLE);
    }

    protected JComponent getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BoxLayout(tablePane, 1));
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        tablePane.add(this.SCROLL_PANE);
        this.TABLE_PANE = tablePane;
        return tablePane;
    }

    public T getDataModel() {
        return this.DATA_MODEL;
    }

    @Override
    public void add(I o) {
        this.add(o, -1);
    }

    public void add(I o, int index) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.SETTINGS.REAL_TIME_SORT.getValue() && this.DATA_MODEL.isSorted() ? this.DATA_MODEL.addSorted(o) : (index >= 0 && index <= this.DATA_MODEL.getRowCount() ? this.DATA_MODEL.add(o, index) : this.DATA_MODEL.add(o));
        this.fixSelection(addedAt, inView);
    }

    public void addUnsorted(I o) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.DATA_MODEL.add(o);
        this.fixSelection(addedAt, inView);
    }

    private void fixSelection(int addedAt, boolean inView) {
        if (addedAt >= 0 && addedAt < this.DATA_MODEL.getRowCount()) {
            this.TABLE.removeRowSelectionInterval(addedAt, addedAt);
            int selected = this.TABLE.getSelectedRow();
            if (selected >= 0 && selected < this.DATA_MODEL.getRowCount()) {
                this.TABLE.addRowSelectionInterval(selected, selected);
                if (inView) {
                    this.TABLE.ensureRowVisible(selected);
                }
            }
        }
    }

    @Override
    public void remove(I o) {
        int idx = this.DATA_MODEL.getRow(o);
        if (idx != -1) {
            this.removeRow(idx);
        }
    }

    private void removeRow(int row) {
        this.DATA_MODEL.remove(row);
    }

    @Override
    public void refresh() {
        if (this.TABLE.isShowing()) {
            this.doRefresh();
            this.resort();
        }
    }

    protected void doRefresh() {
        this.DATA_MODEL.refresh();
    }

    @Override
    public void update(I o) {
        this.DATA_MODEL.update(o);
        this.resort();
    }

    private void resort() {
        this.RESORTER.doResort(false);
    }

    protected void forceResort() {
        this.RESORTER.doResort(true);
    }

    @Override
    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void removeSelection() {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        for (int counter = sel.length - 1; counter >= 0; --counter) {
            int i = sel[counter];
            this.DATA_MODEL.remove(i);
        }
        this.clearSelection();
    }

    private JPopupMenu createColumnSelectionMenu() {
        return new ColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    public void handleMouseClick(MouseEvent e) {
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent e) {
        this.handleActionKey();
    }

    @Override
    public void handleRightMouseClick(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.TABLE.rowAtPoint(p);
        if (row < 0) {
            return;
        }
        if (!this.TABLE.getSelectionModel().isSelectedIndex(row)) {
            this.TABLE.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    @Override
    public void handlePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        this.handleRightMouseClick(e);
        JPopupMenu menu = this.createPopupMenu();
        if (menu != null) {
            try {
                menu.show(this.TABLE, p.x + 1, p.y - 6);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleHeaderColumnLeftClick(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        int oldC = this.DATA_MODEL.getSortColumn();
        if (c != -1) {
            this.sortAndMaintainSelection(c);
            th.repaint(th.getHeaderRect(col));
            if (oldC != -1 && oldC != c) {
                int oldCol = this.TABLE.convertColumnIndexToView(oldC);
                th.repaint(th.getHeaderRect(oldCol));
            }
        }
    }

    @Override
    public void handleHeaderPopupMenu(Point p) {
        this.createColumnSelectionMenu().show(this.TABLE.getTableHeader(), p.x + 1, p.y - 6);
    }

    @Override
    public void handleHeaderColumnPressed(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        if (c != -1) {
            this.TABLE.setPressedColumnIndex(c);
            th.repaint(th.getHeaderRect(col));
        }
    }

    @Override
    public void handleHeaderColumnReleased(Point p) {
        this.TABLE.setPressedColumnIndex(-1);
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        if (col != -1) {
            th.repaint(th.getHeaderRect(col));
        }
    }

    @Override
    public void setButtonEnabled(int buttonIdx, boolean enabled) {
        if (this.BUTTON_ROW != null) {
            this.BUTTON_ROW.setButtonEnabled(buttonIdx, enabled);
        }
    }

    public int getSize() {
        return this.DATA_MODEL.getRowCount();
    }

    public void clearTable() {
        this.DATA_MODEL.clear();
        this.handleNoSelection();
    }

    public void clearSelection() {
        this.TABLE.clearSelection();
        this.handleNoSelection();
    }

    protected void sortAndMaintainSelection(int columnToSort) {
        int i;
        int[] rows = this.TABLE.getSelectedRows();
        DataLine[] dls = new DataLine[rows.length];
        DataLine inView = null;
        for (i = 0; i < rows.length; ++i) {
            dls[i] = this.DATA_MODEL.get((int)rows[i]);
            if (inView != null || !this.TABLE.isRowVisible(rows[i])) continue;
            inView = dls[i];
        }
        if (columnToSort == -1) {
            this.DATA_MODEL.resort();
        } else {
            this.DATA_MODEL.sort(columnToSort);
        }
        for (i = 0; i < rows.length; ++i) {
            int sel = this.DATA_MODEL.getRow((DataLine)dls[i]);
            this.TABLE.addRowSelectionInterval(sel, sel);
            if (inView != dls[i]) continue;
            this.TABLE.ensureRowVisible(sel);
            inView = null;
        }
    }

    protected abstract JPopupMenu createPopupMenu();

    public static int compare(Object o1, Object o2) {
        int retval = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1.getClass() == String.class ? StringUtils.compareFullPrimary((String)o1, (String)o2) : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0))));
        return retval;
    }

    boolean isResorting() {
        return this.isResorting;
    }

    protected TableCellRenderer getProgressBarRenderer() {
        if (PROGRESS_BAR_RENDERER == null) {
            PROGRESS_BAR_RENDERER = new ProgressBarRenderer();
        }
        return PROGRESS_BAR_RENDERER;
    }

    protected TableCellRenderer getSpeedRenderer() {
        if (SPEED_RENDERER == null) {
            SPEED_RENDERER = new SpeedRenderer();
        }
        return SPEED_RENDERER;
    }

    protected TableCellRenderer getColorRenderer() {
        if (COLOR_RENDERER == null) {
            COLOR_RENDERER = new ColorRenderer();
        }
        return COLOR_RENDERER;
    }

    protected TableCellRenderer getIconRenderer() {
        if (ICON_RENDERER == null) {
            ICON_RENDERER = new IconRenderer();
        }
        return ICON_RENDERER;
    }

    protected TableCellRenderer getIconAndNameRenderer() {
        if (ICON_AND_NAME_RENDERER == null) {
            ICON_AND_NAME_RENDERER = new IconAndNameRenderer();
        }
        return ICON_AND_NAME_RENDERER;
    }

    protected TableCellRenderer getSourceRenderer() {
        if (SOURCE_RENDERER == null) {
            SOURCE_RENDERER = new SourceRenderer();
        }
        return SOURCE_RENDERER;
    }

    protected TableCellRenderer getActionIconAndNameRenderer() {
        if (ACTION_ICON_AND_NAME_RENDERER == null) {
            ACTION_ICON_AND_NAME_RENDERER = new ActionIconAndNameRenderer();
        }
        return ACTION_ICON_AND_NAME_RENDERER;
    }

    protected TableCellRenderer getSearchResultsActionsRenderer() {
        if (SEARCH_RESULT_ACTIONS_RENDERER == null) {
            SEARCH_RESULT_ACTIONS_RENDERER = new SearchResultActionsRenderer();
        }
        return SEARCH_RESULT_ACTIONS_RENDERER;
    }

    protected TableCellRenderer getDefaultRenderer() {
        if (DEFAULT_RENDERER == null) {
            DEFAULT_RENDERER = new DefaultTableBevelledCellRenderer();
        }
        return DEFAULT_RENDERER;
    }

    protected TableCellRenderer getCenterRenderer() {
        if (CENTER_RENDERER == null) {
            CENTER_RENDERER = new CenteredRenderer();
        }
        return CENTER_RENDERER;
    }

    protected TableCellRenderer getDateRenderer() {
        if (DATE_RENDERER == null) {
            DATE_RENDERER = new DateRenderer();
        }
        return DATE_RENDERER;
    }

    protected TableCellRenderer getNameHolderRenderer() {
        if (NAME_HOLDER_RENDERER == null) {
            NAME_HOLDER_RENDERER = new NameHolderRenderer();
        }
        return NAME_HOLDER_RENDERER;
    }

    protected TransferActionsRenderer getTransferActionsRenderer() {
        if (TRANSFER_ACTIONS_RENDERER == null) {
            TRANSFER_ACTIONS_RENDERER = new TransferActionsRenderer();
        }
        return TRANSFER_ACTIONS_RENDERER;
    }

    protected TransferSeedingRenderer getSeedingRenderer() {
        if (TRANSFER_SEEDING_RENDERER == null) {
            TRANSFER_SEEDING_RENDERER = new TransferSeedingRenderer();
        }
        return TRANSFER_SEEDING_RENDERER;
    }

    protected PaymentOptionsRenderer getPaymentOptionsRenderer() {
        if (PAYMENT_OPTIONS_RENDERER == null) {
            PAYMENT_OPTIONS_RENDERER = new PaymentOptionsRenderer();
        }
        return PAYMENT_OPTIONS_RENDERER;
    }

    protected TransferDetailFilesActionsRenderer getTransferDetailFileActionsRenderer() {
        if (TRANSFER_DETAIL_FILE_ACTIONS_RENDERER == null) {
            TRANSFER_DETAIL_FILE_ACTIONS_RENDERER = new TransferDetailFilesActionsRenderer();
        }
        return TRANSFER_DETAIL_FILE_ACTIONS_RENDERER;
    }

    protected final class Resorter
    implements Runnable {
        private boolean active = false;
        private boolean force = false;

        protected Resorter() {
        }

        void doResort(boolean isForce) {
            if (!this.active && AbstractTableMediator.this.SETTINGS.REAL_TIME_SORT.getValue() && AbstractTableMediator.this.TABLE.isShowing()) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
            this.force |= isForce;
        }

        @Override
        public void run() {
            try {
                if (!AbstractTableMediator.this.TABLE.isEditing() && (this.force || AbstractTableMediator.this.DATA_MODEL.needsResort())) {
                    AbstractTableMediator.this.isResorting = true;
                    AbstractTableMediator.this.sortAndMaintainSelection(-1);
                    AbstractTableMediator.this.isResorting = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.active = false;
            this.force = false;
        }
    }
}

