/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import com.limegroup.gnutella.gui.tables.AbstractActionsHolder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public abstract class AbstractActionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final float BUTTONS_TRANSPARENCY = 0.85f;
    private static final ImageIcon play_solid = GUIMediator.getThemeImage("search_result_play_over");
    private static final AlphaIcon play_transparent = new AlphaIcon(play_solid, 0.85f);
    private static final ImageIcon download_solid = GUIMediator.getThemeImage("search_result_download_over");
    private static final AlphaIcon download_transparent = new AlphaIcon(download_solid, 0.85f);
    private static final ImageIcon share_solid = GUIMediator.getThemeImage("transfers_sharing_over");
    private JLabel labelPlay;
    private JLabel labelDownload;
    private boolean showSolid;
    protected AbstractActionsHolder actionsHolder;

    public AbstractActionsRenderer() {
        this.setupUI();
    }

    protected abstract void onPlayAction();

    protected abstract void onDownloadAction();

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        this.actionsHolder = (AbstractActionsHolder)dataHolder;
        this.showSolid = this.mouseIsOverRow(table, row);
        this.updatePlayButton();
        this.labelPlay.setVisible(this.actionsHolder.isPlayable());
        this.labelDownload.setIcon(this.showSolid ? download_solid : download_transparent);
        this.labelDownload.setVisible(this.actionsHolder.isDownloadable());
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.labelPlay = new JLabel(play_transparent);
        this.labelPlay.setToolTipText(I18n.tr("Play/Preview"));
        this.labelPlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractActionsRenderer.this.labelPlay_mouseReleased(e);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)this.labelPlay, c);
        this.labelDownload = new JLabel(download_transparent);
        this.labelDownload.setToolTipText(I18n.tr("Download"));
        this.labelDownload.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractActionsRenderer.this.labelDownload_mouseReleased(e);
            }
        });
        c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)this.labelDownload, c);
        JLabel labelShare = new JLabel(share_solid);
        labelShare.setToolTipText(I18n.tr("SHARE the download-url or magnet-url of this file with a friend"));
        labelShare.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractActionsRenderer.this.labelShare_mouseReleased(e);
            }
        });
        c = new GridBagConstraints();
        c.gridx = -1;
        c.ipadx = 3;
        this.add((Component)labelShare, c);
        this.setEnabled(true);
    }

    private void labelShare_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.actionsHolder == null || BTDownloadMediator.instance().isActiveTorrentDownload(this.actionsHolder.getFile())) {
                return;
            }
            if (TorrentUtil.askForPermissionToSeedAndSeedDownloads(null)) {
                TorrentUtil.makeTorrentAndDownload(this.actionsHolder.getFile(), null, true);
            }
        }
    }

    private void updatePlayButton() {
        this.cancelEdit();
        this.labelPlay.setIcon(this.actionsHolder.isPlaying() ? GUIMediator.getThemeImage("speaker") : (this.showSolid ? play_solid : play_transparent));
    }

    private void labelPlay_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.actionsHolder.isPlayable() && !this.actionsHolder.isPlaying()) {
            this.onPlayAction();
            this.updatePlayButton();
        }
    }

    private void labelDownload_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.onDownloadAction();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updatePlayButton();
    }
}

