/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.util.Collection;

public class ShellAssociationManager {
    private final Collection<LimeAssociationOption> associations;

    public ShellAssociationManager(Collection<LimeAssociationOption> associations) {
        this.associations = associations;
    }

    public boolean checkAndGrab(boolean prompt) {
        boolean ret = true;
        for (LimeAssociationOption association : this.associations) {
            if (!association.isAllowed()) continue;
            if (association.isAvailable()) {
                association.setEnabled(true);
                continue;
            }
            if (association.isEnabled()) continue;
            ret = false;
        }
        if (!ret && prompt) {
            DialogOption answer = GUIMediator.showYesNoOtherMessage(I18n.tr("One or more files or protocols that FrostWire uses are no longer associated with FrostWire. Would you like FrostWire to re-associate them?"), QuestionsHandler.GRAB_ASSOCIATIONS, I18n.tr("Details"));
            if (answer == DialogOption.YES) {
                for (LimeAssociationOption association : this.associations) {
                    if (!association.isAllowed() || association.isEnabled()) continue;
                    association.setEnabled(true);
                }
            } else if (answer == DialogOption.OTHER) {
                new ConfigureOptionsAction(I18n.tr("File Associations")).actionPerformed(null);
            }
        }
        return ret;
    }
}

