/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchResultActionsHolder;
import com.limegroup.gnutella.gui.search.SearchResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SourceHolder;
import com.limegroup.gnutella.gui.search.TorrentUISearchResult;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

public final class SearchResultDataLine
extends AbstractDataLine<UISearchResult> {
    private final SearchTableColumns COLUMNS;
    private UISearchResult RESULT;
    private List<UISearchResult> _otherResults;
    private NamedMediaType _mediaType;
    private Date addedOn;
    private SearchResultActionsHolder actionsHolder;
    private SearchResultNameHolder name;
    private String seeds;
    private Icon icon;
    private SizeHolder size;
    private SourceHolder source;

    public SearchResultDataLine(SearchTableColumns stc) {
        this.COLUMNS = stc;
    }

    @Override
    public void initialize(UISearchResult sr) {
        super.initialize(sr);
        this.RESULT = sr;
        this._mediaType = NamedMediaType.getFromExtension(this.getExtension());
        this.addedOn = sr.getCreationTime() > 0L ? new Date(sr.getCreationTime()) : null;
        this.actionsHolder = new SearchResultActionsHolder(sr);
        this.name = new SearchResultNameHolder(sr);
        this.seeds = this.RESULT.getSeeds() <= 0 || !(this.RESULT instanceof TorrentUISearchResult) ? "" : String.valueOf(this.RESULT.getSeeds());
        this.icon = this.getIcon();
        this.size = new SizeHolder(this.getSize());
        this.source = new SourceHolder(this.RESULT);
    }

    @Override
    public void update() {
    }

    public String toString() {
        return this.getFilename() + " (" + this.getSeeds() + ")";
    }

    private boolean isDownloading() {
        return this.RESULT.getHash() != null && BTDownloadMediator.instance().isDownloading(this.RESULT.getHash());
    }

    public NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    List<UISearchResult> getOtherResults() {
        if (this._otherResults == null) {
            return Collections.emptyList();
        }
        return this._otherResults;
    }

    boolean isLaunchable() {
        return false;
    }

    Icon getIcon() {
        if (this.isDownloading()) {
            return GUIMediator.getThemeImage("downloading");
        }
        String ext = FilenameUtils.getExtension(this.getFilename());
        return IconManager.instance().getIconForExtension(ext);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    public String getFilename() {
        return this.RESULT.getFilename();
    }

    public String getDisplayName() {
        return this.RESULT.getDisplayName();
    }

    public long getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getSource();
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public boolean isDynamic(int idx) {
        return false;
    }

    @Override
    public boolean isClippable(int idx) {
        switch (idx) {
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 3;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.actionsHolder;
            }
            case 1: {
                return this.seeds;
            }
            case 2: {
                return this.icon;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.size;
            }
            case 5: {
                return this.source;
            }
            case 6: {
                return this.addedOn;
            }
            case 7: {
                return this.getExtension();
            }
        }
        return null;
    }

    public final boolean isSameKindAs(SearchResultDataLine line) {
        return this.getSearchResult().getClass().equals(line.getSearchResult().getClass());
    }

    public final UISearchResult getSearchResult() {
        return this.RESULT;
    }

    public int getSeeds() {
        return this.RESULT.getSeeds();
    }

    public String getHash() {
        return this.RESULT.getHash();
    }

    public SearchEngine getSearchEngine() {
        return this.RESULT.getSearchEngine();
    }
}

