/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NamedMediaType
implements IconAndNameHolder,
Comparable<NamedMediaType> {
    private static final String IMAGE_RESOURCE_PATH = "org/limewire/xml/image/";
    private static final Map<String, NamedMediaType> CACHED_TYPES = new HashMap<String, NamedMediaType>();
    private final MediaType _mediaType;
    private final String _name;
    private final Icon _icon;

    public NamedMediaType(MediaType mt) {
        if (mt == null) {
            throw new NullPointerException("Null media type.");
        }
        this._mediaType = mt;
        this._name = NamedMediaType.constructName(this._mediaType);
        this._icon = this.getIcon(this._mediaType);
    }

    @Override
    public int compareTo(NamedMediaType other) {
        return this._name.compareTo(other._name);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    public String toString() {
        return this._name;
    }

    public MediaType getMediaType() {
        return this._mediaType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof NamedMediaType && this._name.equals(((NamedMediaType)obj)._name);
    }

    public int hashCode() {
        return this._mediaType.hashCode() + this._name.hashCode() + this._icon.hashCode();
    }

    public static NamedMediaType getFromDescription(String description) {
        NamedMediaType type = CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        MediaType mt = MediaType.getMediaTypeForSchema(description);
        return NamedMediaType.getFromMediaType(mt);
    }

    public static NamedMediaType getFromExtension(String extension) {
        MediaType mt = MediaType.getMediaTypeForExtension(extension);
        if (mt == null) {
            return null;
        }
        String description = mt.getMimeType();
        return NamedMediaType.getFromDescription(description);
    }

    public static List<NamedMediaType> getAllNamedMediaTypes() {
        LinkedList<NamedMediaType> allSchemas = new LinkedList<NamedMediaType>();
        MediaType[] allTypes = MediaType.getDefaultMediaTypes();
        for (int i = 0; i < allTypes.length; ++i) {
            if (NamedMediaType.containsMediaType(allSchemas, allTypes[i])) continue;
            allSchemas.add(NamedMediaType.getFromMediaType(allTypes[i]));
        }
        return allSchemas;
    }

    public static NamedMediaType getFromMediaType(MediaType media) {
        String description = media.getMimeType();
        NamedMediaType type = CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        type = new NamedMediaType(media);
        CACHED_TYPES.put(description, type);
        return type;
    }

    private static boolean containsMediaType(List<? extends NamedMediaType> named, MediaType type) {
        for (NamedMediaType namedMediaType : named) {
            if (!namedMediaType.getMediaType().equals(type)) continue;
            return true;
        }
        return false;
    }

    private Icon getIcon(MediaType type) {
        ImageIcon icon;
        if (type == MediaType.getAnyTypeMediaType()) {
            icon = GUIMediator.getThemeImage("lime");
        } else {
            String location = IMAGE_RESOURCE_PATH + type.getMimeType();
            icon = GUIMediator.getImageFromResourcePath(location);
            if (icon == null) {
                return new GUIUtils.EmptyIcon(this.getName(), 16, 16);
            }
        }
        icon.setDescription(this.getName());
        return icon;
    }

    private static String constructName(MediaType type) {
        String name = null;
        String key = type.getDescriptionKey();
        try {
            if (key != null) {
                name = I18n.tr(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (name == null) {
            name = type.getMimeType();
            name = name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
        }
        return name;
    }
}

