/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import java.util.ArrayList;
import java.util.List;

class CompositeFilter
implements TableLineFilter<SearchResultDataLine> {
    private List<TableLineFilter<SearchResultDataLine>> delegates;

    CompositeFilter(int depth) {
        this.delegates = new ArrayList<TableLineFilter<SearchResultDataLine>>(depth);
        for (int i = 0; i < depth; ++i) {
            this.delegates.add(null);
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.delegates.size(); ++i) {
            this.delegates.set(i, AllowFilter.instance());
        }
    }

    @Override
    public boolean allow(SearchResultDataLine line) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            if (this.delegates.get(i).allow(line)) continue;
            return false;
        }
        return true;
    }

    boolean setFilter(int depth, TableLineFilter<SearchResultDataLine> filter) {
        if (filter == this) {
            throw new IllegalArgumentException("Filter must not be composed of itself");
        }
        if (this.delegates.get(depth).equals(filter)) {
            return false;
        }
        this.delegates.set(depth, filter);
        return true;
    }
}

