/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.Graphics;
import java.util.MissingResourceException;
import javax.swing.Icon;

final class CancelSearchIconProxy
implements Icon {
    private static final int PLAIN = 0;
    private static final int SELECTED = 1;
    private static final int ARMED = 2;
    private static Icon PLAIN_ICON;
    private static Icon SELECTED_ICON;
    private static Icon ARMED_ICON;
    private Icon _cancelIcon;
    private int _width;
    private int _height;
    private int _x;
    private int _y;
    private final int style;

    static CancelSearchIconProxy createPlain() {
        return new CancelSearchIconProxy(0);
    }

    static CancelSearchIconProxy createSelected() {
        return new CancelSearchIconProxy(1);
    }

    CancelSearchIconProxy(int style) {
        this.style = style;
        this.setIcon();
    }

    private void setIcon() {
        switch (this.style) {
            case 2: {
                this._cancelIcon = ARMED_ICON;
                break;
            }
            case 1: {
                this._cancelIcon = SELECTED_ICON;
                break;
            }
            case 0: {
                this._cancelIcon = PLAIN_ICON;
            }
        }
        this._width = this._cancelIcon.getIconWidth();
        this._height = this._cancelIcon.getIconHeight();
        this._x = 0;
        this._y = 0;
    }

    static void updateTheme() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                PLAIN_ICON = GUIMediator.getThemeImage("kill");
                try {
                    SELECTED_ICON = GUIMediator.getThemeImage("kill_on");
                }
                catch (MissingResourceException mre) {
                    SELECTED_ICON = PLAIN_ICON;
                }
                ARMED_ICON = SELECTED_ICON;
            }
        });
    }

    @Override
    public int getIconWidth() {
        return this._width;
    }

    @Override
    public int getIconHeight() {
        return this._height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this._x = x;
        this._y = y;
        this._cancelIcon.paintIcon(c, g, x, y);
    }

    boolean shouldKill(int x, int y) {
        int xMax = this._x + this._width;
        int yMax = this._y + this._height;
        if (x < this._x || x > xMax) {
            return false;
        }
        return y >= this._y && y <= yMax;
    }
}

