/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.limewire.util.OSUtils;

public class ShutdownPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shutdown Behavior");
    public static final String LABEL = I18n.tr("You can choose the default shutdown behavior.");
    private JRadioButton shutdownImmediately;
    private JRadioButton minimizeToTray;
    private JCheckBox _checkBoxShowHideExitDialog;

    public ShutdownPaneItem() {
        super(TITLE, LABEL);
        BoxPanel buttonPanel = new BoxPanel();
        String immediateLabel = I18n.tr("Shutdown Immediately");
        String minimizeLabel = I18n.tr("Minimize to System Tray");
        this.shutdownImmediately = new JRadioButton(I18n.tr(immediateLabel));
        this.minimizeToTray = new JRadioButton(I18n.tr(minimizeLabel));
        String showHideExitDialogLabel = I18n.tr("Show dialog to ask before close");
        this._checkBoxShowHideExitDialog = new JCheckBox(showHideExitDialogLabel);
        ButtonGroup bg = new ButtonGroup();
        buttonPanel.add(this.shutdownImmediately);
        bg.add(this.shutdownImmediately);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            buttonPanel.add(this.minimizeToTray);
            bg.add(this.minimizeToTray);
        }
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        mainPanel.add(this._checkBoxShowHideExitDialog);
        mainPanel.add(Box.createHorizontalGlue());
        this.add(mainPanel);
    }

    @Override
    public boolean applyOptions() throws IOException {
        if (this.minimizeToTray.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
        } else {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
        }
        ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(this._checkBoxShowHideExitDialog.isSelected());
        return false;
    }

    @Override
    public void initOptions() {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            this.minimizeToTray.setSelected(true);
        } else {
            this.shutdownImmediately.setSelected(true);
        }
        this._checkBoxShowHideExitDialog.setSelected(ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue());
    }

    @Override
    public boolean isDirty() {
        boolean minimized = ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        boolean reallyMinimized = minimized && ResourceManager.instance().isTrayIconAvailable();
        boolean immediate = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        return this.minimizeToTray.isSelected() != reallyMinimized || this.shutdownImmediately.isSelected() != immediate || this._checkBoxShowHideExitDialog.isSelected() != ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue();
    }
}

