/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UISettings;
import java.io.IOException;
import javax.swing.JCheckBox;

public final class AutoCompletePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Text Autocompletion");
    public static final String LABEL = I18n.tr("You can enable or disable autocompletion of text fields.");
    private final String AUTOCOMPLETE_LABEL = I18n.tr("Enable Autocompletion of Text Fields:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public AutoCompletePaneItem() {
        super(TITLE, LABEL);
        LabeledComponent c = new LabeledComponent(this.AUTOCOMPLETE_LABEL, this.CHECK_BOX, 120, 10);
        this.add(c.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(UISettings.AUTOCOMPLETE_ENABLED.getValue());
    }

    @Override
    public boolean applyOptions() throws IOException {
        UISettings.AUTOCOMPLETE_ENABLED.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        return UISettings.AUTOCOMPLETE_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

