/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.Menu;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.limewire.util.OSUtils;

abstract class AbstractMenu
implements Menu {
    protected final JMenu MENU;

    protected AbstractMenu(String name) {
        this.MENU = new JMenu(new MenuAction(name));
        this.MENU.addMenuListener(new RefreshMenuListener());
    }

    @Override
    public JMenu getMenu() {
        return this.MENU;
    }

    protected JMenuItem addMenuItem(Action action) {
        return this.addMenuItem(action, null);
    }

    protected JMenuItem addMenuItem(Action action, KeyStroke acceleratorKeyStroke) {
        JMenuItem item = new JMenuItem(action);
        if (acceleratorKeyStroke != null) {
            item.setAccelerator(acceleratorKeyStroke);
        }
        this.MENU.add(item);
        return item;
    }

    protected JMenuItem addToggleMenuItem(Action action, boolean selected) {
        JMenuItem item = OSUtils.isMacOSX() ? new JRadioButtonMenuItem(action) : new JCheckBoxMenuItem(action);
        item.setSelected(selected);
        this.MENU.add(item);
        return item;
    }

    protected JMenuItem addToggleMenuItem(ToggleSettingAction action) {
        JMenuItem item = this.addToggleMenuItem(action, action.getSetting().getValue());
        return item;
    }

    protected void addSeparator() {
        this.MENU.addSeparator();
    }

    protected void refresh() {
    }

    private static class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -4311768902578846258L;

        public MenuAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class RefreshMenuListener
    implements MenuListener {
        private RefreshMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            AbstractMenu.this.refresh();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

