/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class WelcomeWindow
extends SetupWindow {
    private static final String TEXT1 = I18n.tr("FrostWire is a Peer to Peer Application that enables you to share files of your choosing with other users connected to the BitTorrent network.");
    private static final String TEXT2 = I18n.tr("Installing and using the program does not constitute a license for obtaining or distributing unauthorized content.");

    WelcomeWindow(SetupManager manager, boolean partial) {
        super(manager, I18n.tr("Welcome"), partial ? I18n.tr("Welcome to the FrostWire setup wizard. FrostWire has recently added new features that require your configuration. FrostWire will guide you through a series of steps to configure these new features.") : I18n.tr("Welcome to the FrostWire setup wizard. FrostWire will guide you through a series of steps to configure FrostWire for optimum performance."));
    }

    @Override
    public Icon getIcon() {
        return GUIMediator.getThemeImage("logo");
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel panel = new JPanel(new GridBagLayout());
        JComponent label1 = this.createPanel(TEXT1, TEXT2);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 10, 0);
        panel.add((Component)label1, c);
        this.setSetupComponent(panel);
    }

    private JComponent createPanel(String text1, String text2) {
        JPanel panel = new JPanel();
        panel.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        panel.setBorder(BorderFactory.createLineBorder(ThemeMediator.LIGHT_BORDER_COLOR));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        MultiLineLabel label1 = new MultiLineLabel(text1, 400);
        label1.setFont(label1.getFont().deriveFont(16.0f));
        label1.setForeground(GUIUtils.hexToColor("333333"));
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)label1, c);
        MultiLineLabel label2 = new MultiLineLabel(text2, 400);
        label2.setFont(label2.getFont().deriveFont(16.0f));
        label2.setForeground(GUIUtils.hexToColor("333333"));
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)label2, c);
        MultiLineLabel label3 = new MultiLineLabel(I18n.tr("FrostWire is free software,") + " ", 400);
        label3.setFont(label3.getFont().deriveFont(16.0f));
        label3.setForeground(GUIUtils.hexToColor("333333"));
        c.anchor = 21;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(10, 10, 10, 0);
        panel.add((Component)label3, c);
        URLLabel findMore = new URLLabel("http://www.frostwire.com/scams", I18n.tr("Do not pay for FrostWire."));
        findMore.setFont(findMore.getFont().deriveFont(16.0f));
        findMore.setForeground(GUIUtils.hexToColor("333333"));
        c.anchor = 21;
        c.gridwidth = 0;
        c.weightx = 1.0;
        panel.add((Component)findMore, c);
        return panel;
    }
}

