/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

abstract class LocalAbstractInfo {
    static final String LIMEWIRE_VERSION = "1";
    String _limewireVersion;
    static final String JAVA_VERSION = "2";
    String _javaVersion;
    protected static final String OS = "3";
    String _os;
    static final String OS_VERSION = "4";
    String _osVersion;
    static final String ARCHITECTURE = "5";
    String _architecture;
    static final String FREE_MEMORY = "6";
    String _freeMemory;
    static final String TOTAL_MEMORY = "7";
    String _totalMemory;
    static final String BUG = "8";
    String _bug;
    static final String CURRENT_THREAD = "9";
    String _currentThread;
    static final String PROPS = "10";
    String _props;
    static final String UPTIME = "11";
    String _upTime;
    static final String CONNECTED = "12";
    String _connected;
    static final String UP_TO_UP = "13";
    String _upToUp;
    static final String UP_TO_LEAF = "14";
    String _upToLeaf;
    static final String LEAF_TO_UP = "15";
    String _leafToUp;
    static final String OLD_CONNECTIONS = "16";
    String _oldConnections;
    static final String ULTRAPEER = "17";
    String _ultrapeer;
    static final String LEAF = "18";
    String _leaf;
    static final String ACTIVE_UPLOADS = "19";
    String _activeUploads;
    static final String QUEUED_UPLOADS = "20";
    String _queuedUploads;
    static final String ACTIVE_DOWNLOADS = "21";
    String _activeDownloads;
    static final String HTTP_DOWNLOADERS = "22";
    String _httpDownloaders;
    static final String WAITING_DOWNLOADERS = "23";
    String _waitingDownloaders;
    static final String ACCEPTED_INCOMING = "24";
    String _acceptedIncoming;
    static final String SHARED_FILES = "25";
    String _sharedFiles;
    static final String OTHER_THREADS = "26";
    String _otherThreads;
    static final String DETAIL = "27";
    String _detail;
    static final String OTHER_BUG = "28";
    String _otherBug;
    static final String JAVA_VENDOR = "29";
    String _javaVendor;
    static final String THREAD_COUNT = "30";
    String _threadCount;
    static final String BUG_NAME = "31";
    String _bugName;
    static final String GUESS_CAPABLE = "32";
    String _guessCapable;
    static final String SOLICITED_CAPABLE = "33";
    String _solicitedCapable;
    static final String LATEST_SIMPP = "34";
    String _latestSIMPP;
    static final String PORT_STABLE = "36";
    String _portStable;
    static final String CAN_DO_FWT = "37";
    String _canDoFWT;
    static final String LAST_REPORTED_PORT = "38";
    String _lastReportedPort;
    static final String EXTERNAL_PORT = "39";
    String _externalPort;
    static final String RECEIVED_IP_PONG = "40";
    String _receivedIpPong;
    static final String FATAL_ERROR = "41";
    String _fatalError;
    static final String RESPONSE_SIZE = "42";
    String _responseSize;
    static final String CT_SIZE = "43";
    String _creationCacheSize;
    static final String VF_VERIFY_SIZE = "44";
    String _vfVerifyingSize;
    static final String VF_BYTE_SIZE = "45";
    String _vfByteSize;
    static final String BB_BYTE_SIZE = "46";
    String _bbSize;
    static final String VF_QUEUE_SIZE = "47";
    String _vfQueueSize;
    static final String WAITING_SOCKETS = "48";
    String _waitingSockets;
    static final String PENDING_TIMEOUTS = "49";
    String _pendingTimeouts;
    static final String PEAK_THREADS = "50";
    String _peakThreads;
    static final String SP2_WORKAROUNDS = "51";
    String _sp2Workarounds;
    static final String LOAD_AVERAGE = "52";
    String _loadAverage;
    static final String PENDING_GCOBJ = "53";
    String _pendingObjects;
    static final String SETTINGS_FREE_SPACE = "54";
    String _settingsFreeSpace;
    static final String INCOMPLETES_FREE_SPACE = "55";
    String _incompleteFreeSpace;
    static final String DOWNLOAD_FREE_SPACE = "56";
    String _downloadFreeSpace;
    static final String HEAP_USAGE = "57";
    String _heapUsage;
    static final String NON_HEAP_USAGE = "58";
    String _nonHeapUsage;
    static final String SLOT_MANAGER = "59";
    String _slotManager;
    static final String NUM_SELECTS = "60";
    String _numSelects;
    static final String NUM_IMMEDIATE_SELECTS = "61";
    String _numImmediateSelects;
    static final String AVG_SELECT_TIME = "62";
    String _avgSelectTime;
    static final String USER_COMMENTS = "63";
    String _userComments;

    LocalAbstractInfo() {
    }

    void addUserComments(String comments) {
        this._userComments = comments;
    }

    public SystemInfoWriters getBasicSystemInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        SystemInfoWriters result = new SystemInfoWriters(sw, pw);
        result.pw.println("FrostWire version " + this._limewireVersion + " build " + FrostWireUtils.getBuildNumber());
        result.pw.println("Java version " + this._javaVersion + " from " + this._javaVendor);
        result.pw.println(this._os + " v. " + this._osVersion + " on " + this._architecture);
        result.pw.println("Free/total memory: " + this._freeMemory + "/" + this._totalMemory);
        result.pw.println();
        return result;
    }

    public String toBugReport() {
        SystemInfoWriters siw = this.getBasicSystemInfo();
        StringWriter sw = siw.sw;
        PrintWriter pw = siw.pw;
        if (this.isFatalError()) {
            pw.println("FATAL ERROR!");
            pw.println();
        }
        pw.println(this._bug);
        pw.println();
        if (this._detail != null) {
            pw.println("Detail: " + this._detail);
            pw.println();
        }
        pw.println("-- class path --");
        pw.println(System.getProperty("java.class.path").replaceAll("\\;|\\:", "\n"));
        pw.println("-- listing session information --");
        pw.println("Current thread: " + this._currentThread);
        pw.println("Active Threads: " + this._threadCount);
        this.append(pw, "Uptime", this._upTime);
        this.append(pw, "Is Connected", this._connected);
        this.append(pw, "Number of Ultrapeer -> Ultrapeer Connections", this._upToUp);
        this.append(pw, "Number of Ultrapeer -> Leaf Connections", this._upToLeaf);
        this.append(pw, "Number of Leaf -> Ultrapeer Connections", this._leafToUp);
        this.append(pw, "Number of Old Connections", this._oldConnections);
        this.append(pw, "Acting as Ultrapeer", this._ultrapeer);
        this.append(pw, "Acting as Shielded Leaf", this._leaf);
        this.append(pw, "Number of Active Uploads", this._activeUploads);
        this.append(pw, "Number of Queued Uploads", this._queuedUploads);
        this.append(pw, "Number of Active Managed Downloads", this._activeDownloads);
        this.append(pw, "Number of Active HTTP Downloaders", this._httpDownloaders);
        this.append(pw, "Number of Waiting Downloads", this._waitingDownloaders);
        this.append(pw, "Received incoming this session", this._acceptedIncoming);
        this.append(pw, "Number of Shared Files", this._sharedFiles);
        this.append(pw, "Guess Capable", this._guessCapable);
        this.append(pw, "Received Solicited UDP", this._solicitedCapable);
        this.append(pw, "SIMPP version", this._latestSIMPP);
        this.append(pw, "Port Stable", this._portStable);
        this.append(pw, "FWT Capable", this._canDoFWT);
        this.append(pw, "Last Reported Port", this._lastReportedPort);
        this.append(pw, "External Port", this._externalPort);
        this.append(pw, "IP Pongs Received", this._receivedIpPong);
        this.append(pw, "Number of Content Response URNs", this._responseSize);
        this.append(pw, "Number of CreationTimeCache URNs", this._creationCacheSize);
        this.append(pw, "VF Byte Cache Size", this._vfByteSize);
        this.append(pw, "VF Verify Cache Size", this._vfVerifyingSize);
        this.append(pw, "VF Queue Size", this._vfQueueSize);
        this.append(pw, "ByteBuffer Cache Size", this._bbSize);
        this.append(pw, "Number of Waiting Sockets", this._waitingSockets);
        this.append(pw, "Number of Pending Timeouts", this._pendingTimeouts);
        this.append(pw, "Peak Number of Thread", this._peakThreads);
        this.append(pw, "Number of SP2 Workarounds", this._sp2Workarounds);
        this.append(pw, "System Load Avg", this._loadAverage);
        this.append(pw, "Objects Pending GC", this._pendingObjects);
        this.append(pw, "Free Space In Settings", this._settingsFreeSpace);
        this.append(pw, "Free Space In Incomplete", this._incompleteFreeSpace);
        this.append(pw, "Free Space In Downloads", this._downloadFreeSpace);
        this.append(pw, "Heap Memory Usage", this._heapUsage);
        this.append(pw, "Non-Heap Memory Usage", this._nonHeapUsage);
        this.append(pw, "SlotManager dump:", this._slotManager);
        this.append(pw, "Number of select calls", this._numSelects);
        this.append(pw, "Number of immediate selects", this._numImmediateSelects);
        this.append(pw, "Average time in select", this._avgSelectTime);
        pw.println();
        if (this._otherThreads != null) {
            pw.println("-- listing threads --");
            pw.println(this._otherThreads);
            pw.println();
        }
        pw.println(this._props);
        pw.println();
        pw.println("**************** Comments from the user ****************\n" + this._userComments);
        pw.flush();
        System.out.println(sw.toString());
        return sw.toString();
    }

    private void append(PrintWriter pw, String k, String v) {
        if (v != null) {
            pw.println(k + ": " + v);
        }
    }

    public String toString() {
        return this._bugName;
    }

    private boolean isFatalError() {
        return this._fatalError != null && this._fatalError.equalsIgnoreCase("true");
    }

    public final class SystemInfoWriters {
        public final StringWriter sw;
        public final PrintWriter pw;

        SystemInfoWriters(StringWriter sWriter, PrintWriter pWriter) {
            this.sw = sWriter;
            this.pw = pWriter;
        }
    }
}

