/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.util.OSUtils;

public class DonationButtons
extends JPanel {
    private static final Color FONT_COLOR = new Color(2045253);

    DonationButtons() {
        this.setLayout(new MigLayout("insets 0, nogrid, ltr, gapx 6", "", "[align center]"));
        this.add(this.createDonateLabel());
        int bitcoinWidth = OSUtils.isLinux() ? 52 : 40;
        int paypalWidth = OSUtils.isLinux() ? 52 : 46;
        this.add((Component)new DonationButton("BTC", "http://www.frostwire.com/bitcoin", I18n.tr("Support FrostWire development with a Bitcoin donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("BCH", "http://www.frostwire.com/bitcoin-cash", I18n.tr("Support FrostWire development with a Bitcoin Cash donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("ETH", "http://www.frostwire.com/ethereum", I18n.tr("Support FrostWire development with an Ether donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("DASH", "http://www.frostwire.com/dash", I18n.tr("Support FrostWire development with a Dash donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("LTC", "http://www.frostwire.com/litecoin", I18n.tr("Support FrostWire development with a Litecoin donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("ZEC", "http://www.frostwire.com/zcash", I18n.tr("Support FrostWire development with a ZCash donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("BTG", "http://www.frostwire.com/bitcoin-gold", I18n.tr("Support FrostWire development with a Bitcoin Gold donation")), "w " + bitcoinWidth + "px!, h 18px!");
        this.add((Component)new DonationButton("PayPal", "https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=XNBZ6GMVTDWQQ", I18n.tr("Support FrostWire development with a Paypal donation")), "w " + paypalWidth + "px!, h 18px!");
    }

    private JLabel createDonateLabel() {
        Font labelFont = this.getFont().deriveFont(1);
        JLabel donateLabel = new JLabel(I18n.tr("Donate") + ":");
        donateLabel.setForeground(FONT_COLOR);
        donateLabel.setFont(labelFont);
        return donateLabel;
    }

    private class DonationButton
    extends JButton {
        DonationButton(String text, String donationURL, String tipText) {
            this.initComponent(text, donationURL, tipText);
        }

        private void initComponent(String text, String donationURL, String tipText) {
            Font buttonFont = new Font("Dialog", 1, 12);
            this.setCursor(new Cursor(12));
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setFont(buttonFont);
            this.setForeground(FONT_COLOR);
            this.setBackground(new Color(15593972));
            this.setText(text);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(0);
            this.setToolTipText(tipText);
            this.addActionListener(e -> GUIMediator.openURL(donationURL));
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 2, 2);
            g.setColor(new Color(15001834));
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 2, 2);
            super.paintComponent(g);
        }
    }
}

