/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.http;

import com.frostwire.util.Logger;
import com.frostwire.util.UserAgentGenerator;
import com.frostwire.util.http.HttpClient;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpClient
implements HttpClient {
    private static final Logger LOG = Logger.getLogger(AbstractHttpClient.class);
    protected static final int DEFAULT_TIMEOUT = 10000;
    protected static final String DEFAULT_USER_AGENT = UserAgentGenerator.getUserAgent();
    protected HttpClient.HttpClientListener listener;
    protected boolean canceled = false;

    @Override
    public void setListener(HttpClient.HttpClientListener listener) {
        this.listener = listener;
    }

    @Override
    public HttpClient.HttpClientListener getListener() {
        return this.listener;
    }

    @Override
    public void onCancel() {
        if (this.getListener() != null) {
            try {
                this.getListener().onCancel(this);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onData(byte[] b, int i, int n) {
        if (this.getListener() != null) {
            this.getListener().onData(this, b, 0, n);
        }
    }

    @Override
    public void onError(Exception e) {
        if (this.getListener() != null) {
            try {
                this.getListener().onError(this, e);
            }
            catch (Exception e2) {
                LOG.warn(e2.getMessage());
            }
        } else {
            e.printStackTrace();
        }
    }

    @Override
    public void onComplete() {
        if (this.getListener() != null) {
            try {
                this.getListener().onComplete(this);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public abstract int head(String var1, int var2, Map<String, List<String>> var3) throws IOException;

    @Override
    public String get(String url) throws IOException {
        return this.get(url, 10000, DEFAULT_USER_AGENT);
    }

    @Override
    public String get(String url, int timeout) throws IOException {
        return this.get(url, timeout, DEFAULT_USER_AGENT);
    }

    @Override
    public String get(String url, int timeout, String userAgent) throws IOException {
        return this.get(url, timeout, userAgent, null, null);
    }

    @Override
    public String get(String url, int timeout, String userAgent, String referrer, String cookie) throws IOException {
        return this.get(url, timeout, userAgent, referrer, cookie, null);
    }

    @Override
    public abstract String get(String var1, int var2, String var3, String var4, String var5, Map<String, String> var6) throws IOException;

    @Override
    public byte[] getBytes(String url) {
        return this.getBytes(url, 10000);
    }

    @Override
    public byte[] getBytes(String url, int timeout) {
        return this.getBytes(url, timeout, null);
    }

    @Override
    public byte[] getBytes(String url, int timeout, String referrer) {
        return this.getBytes(url, timeout, DEFAULT_USER_AGENT, referrer);
    }

    @Override
    public byte[] getBytes(String url, int timeout, String userAgent, String referrer) {
        return this.getBytes(url, timeout, userAgent, referrer, null);
    }

    @Override
    public abstract byte[] getBytes(String var1, int var2, String var3, String var4, String var5);

    @Override
    public void save(String url, File file) throws IOException {
        this.save(url, file, false, 10000, DEFAULT_USER_AGENT);
    }

    @Override
    public void save(String url, File file, boolean resume) throws IOException {
        this.save(url, file, resume, 10000, DEFAULT_USER_AGENT);
    }

    @Override
    public void save(String url, File file, boolean resume, int timeout, String userAgent) throws IOException {
        this.save(url, file, resume, timeout, userAgent, null);
    }

    @Override
    public abstract void save(String var1, File var2, boolean var3, int var4, String var5, String var6) throws IOException;

    @Override
    public abstract String post(String var1, int var2, String var3, Map<String, String> var4) throws IOException;

    @Override
    public String post(String url, int timeout, String userAgent, String content, boolean gzip) throws IOException {
        return this.post(url, timeout, userAgent, content, "text/plain", gzip);
    }

    @Override
    public abstract String post(String var1, int var2, String var3, String var4, String var5, boolean var6) throws IOException;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    protected byte[] getFormDataBytes(Map<String, String> formData) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (formData != null && formData.size() > 0) {
            for (Map.Entry<String, String> kv : formData.entrySet()) {
                sb.append("&");
                sb.append(kv.getKey());
                sb.append("=");
                sb.append(kv.getValue());
            }
            sb.deleteCharAt(0);
        }
        return sb.toString().getBytes("UTF-8");
    }

    protected static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void copyMultiMap(Map<String, List<String>> origin, Map<String, List<String>> destination) {
        if (origin == null || destination == null) {
            return;
        }
        for (String key : origin.keySet()) {
            destination.put(key, origin.get(key));
        }
    }
}

