/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import org.limewire.util.OSUtils;

public class WinRegistryWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ITEM_EXIST = 0;
    public static final int ERROR_ITEM_NOTEXIST = 9;
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_NAME_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;

    private static native int[] RegOpenKey(int var0, byte[] var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native int[] RegCreateKeyEx(int var0, byte[] var1);

    private static native int RegDeleteKey(int var0, byte[] var1);

    private static native int RegFlushKey(int var0);

    private static native byte[] RegQueryValueEx(int var0, byte[] var1);

    private static native int RegSetValueEx(int var0, byte[] var1, byte[] var2);

    private static native int RegDeleteValue(int var0, byte[] var1);

    private static native int[] RegQueryInfoKey(int var0);

    private static native byte[] RegEnumKeyEx(int var0, int var1, int var2);

    private static native byte[] RegEnumValue(int var0, int var1, int var2);

    private static native byte[] FindMimeFromData(byte[] var0, byte[] var1);

    private static native byte[] ExpandEnvironmentStrings(byte[] var0);

    private static byte[] stringToByteArray(String str) {
        if (str == null) {
            return null;
        }
        byte[] srcByte = str.getBytes();
        int srcLength = srcByte.length;
        byte[] result = new byte[srcLength + 1];
        System.arraycopy(srcByte, 0, result, 0, srcLength);
        result[srcLength] = 0;
        return result;
    }

    private static String byteArrayToString(byte[] array) {
        String temString;
        if (array != null && (temString = new String(array)) != null) {
            return temString.substring(0, temString.length() - 1);
        }
        return null;
    }

    private WinRegistryWrapper() {
    }

    public static int WinRegCreateKeyEx(int hKey, String subKey) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] createResult = WinRegistryWrapper.RegCreateKeyEx(hKey, lpSubKey);
        if (createResult == null) {
            return -1;
        }
        if (createResult[1] == 0) {
            WinRegistryWrapper.RegCloseKey(createResult[0]);
        }
        return createResult[1];
    }

    public static int WinRegDeleteKey(int hKey, String subKey) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int result = WinRegistryWrapper.RegDeleteKey(hKey, lpSubKey);
        if (result == 0) {
            return result;
        }
        int res = WinRegistryWrapper.WinRegSubKeyExist(hKey, subKey);
        if (res == 9) {
            return result;
        }
        String[] subSubKeys = WinRegistryWrapper.WinRegGetSubKeys(hKey, subKey, 255);
        if (subSubKeys == null) {
            return result;
        }
        for (int keyIndex = 0; keyIndex < subSubKeys.length; ++keyIndex) {
            String subSubKey = subKey + "\\" + subSubKeys[keyIndex];
            if (subSubKey == null) continue;
            WinRegistryWrapper.WinRegDeleteKey(hKey, subSubKey);
        }
        result = WinRegistryWrapper.RegDeleteKey(hKey, lpSubKey);
        return result;
    }

    public static int WinRegFlushKey(int hKey, String subKey) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131078);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        int flushResult = WinRegistryWrapper.RegFlushKey(openResult[0]);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return flushResult;
    }

    public static String WinRegQueryValueEx(int hKey, String subKey, String valueName) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        byte[] lpValueName = WinRegistryWrapper.stringToByteArray(valueName);
        byte[] valueBytes = WinRegistryWrapper.RegQueryValueEx(openResult[0], lpValueName);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        if (valueBytes != null) {
            if (valueBytes.length == 1 && valueBytes[0] == 0 && valueName.equals("")) {
                return null;
            }
            return WinRegistryWrapper.byteArrayToString(valueBytes);
        }
        return null;
    }

    public static int WinRegSetValueEx(int hKey, String subKey, String valueName, String value) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 2);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        byte[] lpValueName = WinRegistryWrapper.stringToByteArray(valueName);
        byte[] lpValue = WinRegistryWrapper.stringToByteArray(value);
        int setResult = WinRegistryWrapper.RegSetValueEx(openResult[0], lpValueName, lpValue);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return setResult;
    }

    public static int WinRegDeleteValue(int hKey, String subKey, String valueName) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131078);
        if (openResult == null) {
            return -1;
        }
        if (openResult[1] != 0) {
            return openResult[1];
        }
        byte[] lpValueName = WinRegistryWrapper.stringToByteArray(valueName);
        int deleteResult = WinRegistryWrapper.RegDeleteValue(openResult[0], lpValueName);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return deleteResult;
    }

    public static int[] WinRegQueryInfoKey(int hKey, String subKey) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return openResult;
        }
        int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return queryResult;
    }

    public static String WinRegEnumKeyEx(int hKey, String subKey, int subKeyIndex, int maxKeyLength) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        byte[] keyBytes = WinRegistryWrapper.RegEnumKeyEx(openResult[0], subKeyIndex, maxKeyLength);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        if (keyBytes != null) {
            return WinRegistryWrapper.byteArrayToString(keyBytes);
        }
        return null;
    }

    public static String WinRegEnumValue(int hKey, String subKey, int valueIndex, int maxValueNameLength) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        byte[] valueBytes = WinRegistryWrapper.RegEnumValue(openResult[0], valueIndex, maxValueNameLength);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        if (valueBytes != null) {
            return WinRegistryWrapper.byteArrayToString(valueBytes);
        }
        return null;
    }

    public static String[] WinRegGetSubKeys(int hKey, String subKey, int maxKeyLength) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
        int subKeysNum = queryResult[0];
        if (subKeysNum == 0) {
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return null;
        }
        String[] keyStrings = new String[subKeysNum];
        for (int subKeyIndex = 0; subKeyIndex < subKeysNum; ++subKeyIndex) {
            byte[] keyBytes = WinRegistryWrapper.RegEnumKeyEx(openResult[0], subKeyIndex, maxKeyLength);
            keyStrings[subKeyIndex] = WinRegistryWrapper.byteArrayToString(keyBytes);
        }
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return keyStrings;
    }

    public static String[] WinRegGetValues(int hKey, String subKey, int maxValueLength) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        int[] queryResult = WinRegistryWrapper.RegQueryInfoKey(openResult[0]);
        int valuesNum = queryResult[2];
        if (valuesNum == 0) {
            WinRegistryWrapper.RegCloseKey(openResult[0]);
            return null;
        }
        String[] valueStrings = new String[valuesNum];
        for (int valueIndex = 0; valueIndex < valuesNum; ++valueIndex) {
            byte[] valueBytes = WinRegistryWrapper.RegEnumValue(openResult[0], valueIndex, maxValueLength);
            valueStrings[valueIndex] = WinRegistryWrapper.byteArrayToString(valueBytes);
        }
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return valueStrings;
    }

    public static int WinRegSubKeyExist(int hKey, String subKey) {
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return 9;
        }
        if (openResult[1] != 0) {
            return 9;
        }
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        return 0;
    }

    public static int WinRegValueExist(int hKey, String subKey, String valueName) {
        if (subKey.trim().equals("")) {
            return 9;
        }
        byte[] lpSubKey = WinRegistryWrapper.stringToByteArray(subKey);
        int[] openResult = WinRegistryWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return 9;
        }
        if (openResult[1] != 0) {
            return 9;
        }
        byte[] lpValueName = WinRegistryWrapper.stringToByteArray(valueName);
        byte[] valueBytes = WinRegistryWrapper.RegQueryValueEx(openResult[0], lpValueName);
        WinRegistryWrapper.RegCloseKey(openResult[0]);
        if (valueBytes == null) {
            return 9;
        }
        if (valueBytes.length == 1 && valueBytes[0] == 0 && valueName.equals("")) {
            return 9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String WinFindMimeFromData(URL url) {
        String urlString = url.toString();
        byte[] urlBytes = WinRegistryWrapper.stringToByteArray(urlString);
        byte[] result = WinRegistryWrapper.FindMimeFromData(urlBytes, null);
        if (result != null) {
            return WinRegistryWrapper.byteArrayToString(result);
        }
        byte[] dataBytes = new byte[256];
        DataInputStream inStream = null;
        try {
            inStream = new DataInputStream(url.openStream());
            inStream.read(dataBytes, 0, 256);
            inStream.close();
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        result = WinRegistryWrapper.FindMimeFromData(null, dataBytes);
        if (result != null) {
            return WinRegistryWrapper.byteArrayToString(result);
        }
        return null;
    }

    public static String WinExpandEnvironmentStrings(String envVariable) {
        byte[] envVariableBytes = WinRegistryWrapper.stringToByteArray(envVariable);
        byte[] resultBytes = WinRegistryWrapper.ExpandEnvironmentStrings(envVariableBytes);
        return WinRegistryWrapper.byteArrayToString(resultBytes);
    }

    static {
        try {
            if (OSUtils.isWindows() && OSUtils.isGoodWindows()) {
                if (OSUtils.isMachineX64()) {
                    System.loadLibrary("SystemUtilitiesX64");
                } else {
                    System.loadLibrary("SystemUtilities");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

