/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.AppUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Association {
    private String name;
    private String description;
    private String mimeType;
    private List<String> fileExtensionList;
    private String iconFileName;
    private List<Action> actionList;
    private int hashcode;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The given MIME file name is null.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("The given description is null.");
        }
        this.description = description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("The given MIME type is null.");
        }
        this.mimeType = mimeType;
    }

    public boolean addFileExtension(String fileExt) {
        if (fileExt == null) {
            throw new IllegalArgumentException("The given file extension is null.");
        }
        fileExt = AppUtility.addDotToFileExtension(fileExt);
        if (this.fileExtensionList == null) {
            this.fileExtensionList = new ArrayList<String>();
        }
        return this.fileExtensionList.add(fileExt);
    }

    public boolean removeFileExtension(String fileExt) {
        if (fileExt == null) {
            throw new IllegalArgumentException("The given file extension is null.");
        }
        fileExt = AppUtility.addDotToFileExtension(fileExt);
        if (this.fileExtensionList != null) {
            return this.fileExtensionList.remove(fileExt);
        }
        return false;
    }

    public List<String> getFileExtList() {
        if (this.fileExtensionList == null) {
            return null;
        }
        ArrayList<String> retList = new ArrayList<String>();
        Iterator<String> iter = this.fileExtensionList.iterator();
        while (iter.hasNext()) {
            retList.add(iter.next());
        }
        return retList;
    }

    public String getIconFileName() {
        return this.iconFileName;
    }

    public void setIconFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("The given icon file name is null.");
        }
        this.iconFileName = fileName;
    }

    public boolean addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("The given action is null.");
        }
        if (action.getVerb() == null) {
            throw new IllegalArgumentException("the given action object has null verb field.");
        }
        if (action.getCommand() == null) {
            throw new IllegalArgumentException("the given action object has null command field.");
        }
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
        }
        return this.actionList.add(new Action(action.getVerb(), action.getCommand(), action.getDescription()));
    }

    public boolean removeAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("The given action is null.");
        }
        if (action.getVerb() == null || action.getCommand() == null) {
            throw new IllegalArgumentException("the given action object has null verb field or command field.");
        }
        if (this.actionList != null) {
            return this.actionList.remove(action);
        }
        return false;
    }

    public List<Action> getActionList() {
        if (this.actionList == null || this.actionList.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Action>(this.actionList);
    }

    public Action getActionByVerb(String verb) {
        Iterator<Action> iter;
        if (this.actionList != null && (iter = this.actionList.iterator()) != null) {
            while (iter.hasNext()) {
                Action temAction = iter.next();
                String temVerb = temAction.getVerb();
                if (!temVerb.equalsIgnoreCase(verb)) continue;
                return temAction;
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        boolean isBasicEquals;
        if (!(other instanceof Association)) {
            return false;
        }
        Association otherAssoc = (Association)other;
        String otherDesc = otherAssoc.getDescription();
        String otherIconFileName = otherAssoc.getIconFileName();
        String otherMimeType = otherAssoc.getMimeType();
        boolean bl = (this.description == null ? otherDesc == null : this.description.equals(otherDesc)) && (this.iconFileName == null ? otherIconFileName == null : this.iconFileName.equals(otherIconFileName)) && (this.mimeType == null ? otherMimeType == null : this.mimeType.equals(otherMimeType)) ? true : (isBasicEquals = false);
        if (!isBasicEquals) {
            return false;
        }
        List<String> otherFileExtList = otherAssoc.getFileExtList();
        boolean isFileExtListEquals = false;
        if (this.fileExtensionList == null && otherFileExtList == null) {
            isFileExtListEquals = true;
        } else if (this.fileExtensionList != null && otherFileExtList != null && this.fileExtensionList.containsAll(otherFileExtList) && otherFileExtList.containsAll(this.fileExtensionList)) {
            isFileExtListEquals = true;
        }
        if (!isFileExtListEquals) {
            return false;
        }
        List<Action> otherActionList = otherAssoc.getActionList();
        boolean isActionListEquals = false;
        if (this.actionList == null && otherActionList != null) {
            isActionListEquals = true;
        } else if (this.actionList != null && otherActionList != null && this.actionList.containsAll(otherActionList) && otherActionList.containsAll(this.actionList)) {
            isActionListEquals = true;
        }
        return isActionListEquals;
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            int result = 17;
            if (this.name != null) {
                result = result * 37 + this.name.hashCode();
            }
            if (this.description != null) {
                result = result * 37 + this.description.hashCode();
            }
            if (this.mimeType != null) {
                result = result * 37 + this.mimeType.hashCode();
            }
            if (this.iconFileName != null) {
                result = result * 37 + this.iconFileName.hashCode();
            }
            if (this.fileExtensionList != null) {
                result = result * 37 + this.fileExtensionList.hashCode();
            }
            if (this.actionList != null) {
                result = result * 37 + this.actionList.hashCode();
            }
            this.hashcode = result;
        }
        return this.hashcode;
    }

    public String toString() {
        Iterator<Object> temIter;
        String crlfString = "\r\n";
        String content = "";
        content = content.concat("MIME File Name: ");
        if (this.name != null) {
            content = content.concat(this.name);
        }
        content = content.concat(crlfString);
        content = content.concat("Description: ");
        if (this.description != null) {
            content = content.concat(this.description);
        }
        content = content.concat(crlfString);
        content = content.concat("MIME Type: ");
        if (this.mimeType != null) {
            content = content.concat(this.mimeType);
        }
        content = content.concat(crlfString);
        content = content.concat("Icon File: ");
        if (this.iconFileName != null) {
            content = content.concat(this.iconFileName);
        }
        content = content.concat(crlfString);
        content = content.concat("File Extension: ");
        if (this.fileExtensionList != null && (temIter = this.fileExtensionList.iterator()) != null) {
            while (temIter.hasNext()) {
                content = content.concat(temIter.next());
                if (!temIter.hasNext()) continue;
                content = content.concat(" ");
            }
        }
        content = content.concat(crlfString);
        content = content.concat("Action List: ");
        if (this.actionList != null && (temIter = this.actionList.iterator()) != null) {
            content = content.concat(crlfString);
            while (temIter.hasNext()) {
                Action temAction = (Action)temIter.next();
                content = content.concat(temAction.toString());
            }
        }
        content = content.concat(crlfString);
        return content;
    }
}

