/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.zooqle;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.PerformersHelper;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class ZooqleSearchResult
extends AbstractTorrentSearchResult {
    private static final String FILE_SIZE_REGEX = "title=\"File size\"></i>(?<size>[\\d\\.\\,]*) (?<sizeUnit>.{2}?)";
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("title=\"File size\"></i>(?<size>[\\d\\.\\,]*) (?<sizeUnit>.{2}?)");
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    ZooqleSearchResult(String detailsUrl, String urlPrefix, SearchMatcher matcher) {
        String magnetUrl;
        this.detailsUrl = detailsUrl;
        this.filename = matcher.group("filename") + ".torrent";
        this.displayName = matcher.group("filename");
        this.seeds = Integer.valueOf(matcher.group("seeds").trim());
        this.torrentUrl = magnetUrl = "magnet:?xt=urn:btih:" + matcher.group("magnet");
        this.infoHash = PerformersHelper.parseInfoHash(magnetUrl);
        this.size = this.calculateSize(matcher.group("sizedata"));
        this.creationTime = this.parseCreationTime(matcher.group("year") + " " + matcher.group("month") + " " + matcher.group("day"));
    }

    private long calculateSize(String sizedata) {
        if (sizedata.contains("Filesize yet unknown")) {
            return -1L;
        }
        Matcher fileSizeMatcher = FILE_SIZE_PATTERN.matcher(sizedata);
        if (fileSizeMatcher.find()) {
            return this.calculateSize(fileSizeMatcher.group("size"), fileSizeMatcher.group("sizeUnit"));
        }
        return -1L;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getSource() {
        return "Zooqle";
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            SimpleDateFormat myFormat = new SimpleDateFormat("yyyy MMM d", Locale.US);
            result = myFormat.parse(dateString).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

