/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.yify;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.TorrentRegexSearchPerformer;
import com.frostwire.search.yify.YifySearchResult;
import com.frostwire.search.yify.YifyTempSearchResult;

public final class YifySearchPerformer
extends TorrentRegexSearchPerformer<YifySearchResult> {
    private static final int MAX_RESULTS = 21;
    public static final String SEARCH_RESULTS_REGEX = "(?is)<figcaption><h3><a class=\"movielink\" href=\"/movie/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\">";
    public static final String TORRENT_DETAILS_PAGE_REGEX = "(?is)<section id=\"movie\".*?<h1 itemprop=\"name\">(?<displayName>.*?)</h1>.*?<img itemprop=\"image\" src=\"(?<cover>.*?)\".*?<dt>Size:</dt> <dd>(?<size>.*?)</dd>.*?<dt>Language:</dt> <dd>(?<language>.*?)</dd>.*?<dt>Add Date:</dt> <dd><span.*?>(?<creationDate>.*?)</span></dd>.*?<dt>Seeds:</dt> <dd>(?<seeds>[0-9]+)</dd>.*?<a href=\"(?<magnet>.*?)\" id=\"dm\" class=\"button button-default\".*?>Download Magnet</a>.*?";

    public YifySearchPerformer(String domainName, long token, String keywords, int timeout) {
        super(domainName, token, keywords, timeout, 1, 42, 21, SEARCH_RESULTS_REGEX, TORRENT_DETAILS_PAGE_REGEX);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search/" + encodedKeywords + "/";
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group("itemId");
        String htmlFileName = matcher.group("htmlFileName");
        return new YifyTempSearchResult(this.getDomainName(), itemId, htmlFileName);
    }

    @Override
    protected YifySearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new YifySearchResult(sr.getDetailsUrl(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        return html != null && !html.contains("Cloudflare");
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("<div id=\"content\"");
        return offset > 0 ? offset : 0;
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf("<section id=\"movie_bottom\">");
        return offset > 0 ? offset : html.length();
    }
}

