/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.search.AbstractCrawledSearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.search.torrent.TorrentItemSearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class TorrentCrawledAlbumSearchResult
extends AbstractCrawledSearchResult<TorrentCrawlableSearchResult>
implements TorrentSearchResult {
    private final String artist;
    private final String album;
    private final List<TorrentItemSearchResult> items;
    private final String displayName;
    private final long size;

    public TorrentCrawledAlbumSearchResult(TorrentCrawlableSearchResult sr, String artist, String album, List<TorrentItemSearchResult> items) {
        super(sr);
        this.artist = artist;
        this.album = album;
        this.items = items;
        this.displayName = this.buildDisplayName(artist, album);
        this.size = this.buildSize(items);
    }

    public String artist() {
        return this.artist;
    }

    public String album() {
        return this.album;
    }

    public List<TorrentItemSearchResult> items() {
        return this.items;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return ((TorrentCrawlableSearchResult)this.parent).getFilename();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getTorrentUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getTorrentUrl();
    }

    @Override
    public String getReferrerUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getReferrerUrl();
    }

    @Override
    public int getSeeds() {
        return ((TorrentCrawlableSearchResult)this.parent).getSeeds();
    }

    @Override
    public String getHash() {
        return ((TorrentCrawlableSearchResult)this.parent).getHash();
    }

    @Override
    public String getThumbnailUrl() {
        return ((TorrentCrawlableSearchResult)this.parent).getThumbnailUrl();
    }

    @Override
    public String toString() {
        return "Torrent Album: " + this.displayName + ", files: " + this.items.size() + ", size: " + this.size;
    }

    private String buildDisplayName(String artist, String album) {
        String result = "";
        result = StringUtils.isNotBlank(album) ? album : "Unknown album";
        if (StringUtils.isNotBlank(artist)) {
            result = artist + " - " + album;
        }
        return result;
    }

    private long buildSize(List<TorrentItemSearchResult> items) {
        long r = 0L;
        for (TorrentItemSearchResult sr : items) {
            r += sr.getSize();
        }
        return r;
    }
}

