/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.limetorrents;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public final class LimeTorrentsSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    LimeTorrentsSearchResult(String detailsUrl, SearchMatcher matcher) {
        this.detailsUrl = detailsUrl;
        this.infoHash = matcher.group("torrentid");
        this.filename = this.parseFileName(matcher.group("filename"));
        this.size = this.parseSize(matcher.group("filesize") + " " + matcher.group("unit"));
        this.creationTime = this.parseCreationTime(matcher.group("time"));
        this.seeds = this.parseSeeds(matcher.group("seeds"));
        this.torrentUrl = "magnet:" + matcher.group("magnet_part");
        this.displayName = HtmlManipulator.replaceHtmlEntities(FilenameUtils.getBaseName(this.filename));
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "LimeTorrents";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String decodedFileName) {
        return HtmlManipulator.replaceHtmlEntities(decodedFileName.trim()) + ".torrent";
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            if (dateString.contains("1 Year+")) {
                return result - 31536000000L;
            }
            if (dateString.contains("Last Month")) {
                return result - 2678400000L;
            }
            if (dateString.contains("Yesterday")) {
                return result - 86400000L;
            }
            SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            result = myFormat.parse(dateString.trim()).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

