/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.regex.Pattern;
import com.frostwire.search.AbstractCrawledSearchResult;
import com.frostwire.search.AlbumCluster;
import com.frostwire.search.RegexSearchPerformer;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.search.torrent.TorrentCrawledSearchResult;
import com.frostwire.util.Logger;
import java.util.LinkedList;
import java.util.List;

public final class PerformersHelper {
    private static final Logger LOG = Logger.getLogger(PerformersHelper.class);
    private static final Pattern MAGNET_HASH_PATTERN = Pattern.compile("magnet\\:\\?xt\\=urn\\:btih\\:([a-fA-F0-9]{40})");

    private PerformersHelper() {
    }

    public static List<? extends SearchResult> searchPageHelper(RegexSearchPerformer<?> performer, String page, int regexMaxResults) {
        boolean matcherFound;
        LinkedList result = new LinkedList();
        if (page == null) {
            LOG.warn(performer.getClass().getSimpleName() + " returning null page. Issue fetching page or issue getting page prefix/suffix offsets. Notify developers at contact@frostwire.com");
            return result;
        }
        SearchMatcher matcher = SearchMatcher.from(performer.getPattern().matcher(page));
        int max = regexMaxResults;
        int i = 0;
        do {
            Object sr;
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error(performer.getPattern().toString() + " has failed.\n" + t.getMessage(), t);
            }
            if (!matcherFound || (sr = performer.fromMatcher(matcher)) == null) continue;
            result.add(sr);
            ++i;
        } while (matcherFound && i < max && !performer.isStopped());
        return result;
    }

    public static List<? extends SearchResult> crawlTorrent(SearchPerformer performer, TorrentCrawlableSearchResult sr, byte[] data, boolean detectAlbums) {
        LinkedList<TorrentCrawledSearchResult> list = new LinkedList<TorrentCrawledSearchResult>();
        if (data == null) {
            return list;
        }
        TorrentInfo ti = TorrentInfo.bdecode(data);
        int numFiles = ti.numFiles();
        FileStorage fs = ti.files();
        for (int i = 0; !performer.isStopped() && i < numFiles; ++i) {
            if (fs.padFileAt(i)) continue;
            list.add(new TorrentCrawledSearchResult(sr, ti, i, fs.filePath(i), fs.fileSize(i)));
        }
        if (detectAlbums) {
            LinkedList<AbstractCrawledSearchResult> temp = new LinkedList<AbstractCrawledSearchResult>();
            temp.addAll(list);
            temp.addAll(new AlbumCluster().detect(sr, list));
            return temp;
        }
        return list;
    }

    public static List<? extends SearchResult> crawlTorrent(SearchPerformer performer, TorrentCrawlableSearchResult sr, byte[] data) {
        return PerformersHelper.crawlTorrent(performer, sr, data, false);
    }

    public static String parseInfoHash(String url) {
        String result = null;
        SearchMatcher matcher = SearchMatcher.from(MAGNET_HASH_PATTERN.matcher(url));
        try {
            if (matcher.find()) {
                result = matcher.group(1);
            }
        }
        catch (Throwable t) {
            LOG.error("Could not parse magnet out of " + url, t);
        }
        return result;
    }

    public static String reduceHtml(String html, int prefixOffset, int suffixOffset) {
        int preOffset = prefixOffset;
        int sufOffset = suffixOffset;
        if (preOffset == -1 || sufOffset == -1) {
            html = null;
        } else if (preOffset > 0 || sufOffset < html.length()) {
            if (preOffset > suffixOffset) {
                LOG.warn("PerformersHelper.reduceHtml() Check your logic: prefixOffset:" + prefixOffset + " > suffixOffset:" + suffixOffset);
                LOG.info(html);
                return null;
            }
            html = new String(html.substring(preOffset, sufOffset).toCharArray());
        }
        return html;
    }
}

