/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.BoxEntry;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class SampleSizeBox
extends FullBox {
    protected int sample_size;
    protected int sample_count;
    protected Entry[] entries;

    SampleSizeBox() {
        super(stsz);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 8, buf);
        this.sample_size = buf.getInt();
        this.sample_count = buf.getInt();
        this.entries = new Entry[this.sample_count];
        for (int i = 0; i < this.sample_count; ++i) {
            Entry e = new Entry();
            IO.read(ch, 4, buf);
            e.get(buf);
            this.entries[i] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.sample_size);
        buf.putInt(this.sample_count);
        IO.write(ch, 8, buf);
        IsoMedia.write(ch, this.sample_count, 4, this.entries, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 8L;
        this.length(s += (long)(this.sample_count * 4));
    }

    public static final class Entry
    extends BoxEntry {
        public int entry_size;

        @Override
        void get(ByteBuffer buf) {
            this.entry_size = buf.getInt();
        }

        @Override
        void put(ByteBuffer buf) {
            buf.putInt(this.entry_size);
        }
    }
}

