/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class SampleEntry
extends Box {
    protected final byte[] reserved;
    protected short data_reference_index;

    SampleEntry(int format) {
        super(format);
        this.boxes = new LinkedList();
        this.reserved = new byte[6];
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        IO.read(ch, 8, buf);
        buf.get(this.reserved);
        this.data_reference_index = buf.getShort();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        buf.put(this.reserved);
        buf.putShort(this.data_reference_index);
        IO.write(ch, 8, buf);
    }
}

