/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MovieHeaderBox
extends FullBox {
    protected long creation_time;
    protected long modification_time;
    protected int timescale;
    protected long duration;
    protected int rate = 65536;
    protected short volume = (short)256;
    protected short reserved1;
    protected final int[] reserved2 = new int[2];
    protected final int[] matrix = new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000};
    protected final int[] pre_defined = new int[6];
    protected int next_track_ID;

    MovieHeaderBox() {
        super(mvhd);
    }

    public int timescale() {
        return this.timescale;
    }

    public void timescale(int value) {
        this.timescale = value;
    }

    public long duration() {
        return this.duration;
    }

    public void duration(long value) {
        this.duration = value;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, (this.version == 1 ? 28 : 16) + 80, buf);
        if (this.version == 1) {
            this.creation_time = buf.getLong();
            this.modification_time = buf.getLong();
            this.timescale = buf.getInt();
            this.duration = buf.getLong();
        } else {
            this.creation_time = buf.getInt();
            this.modification_time = buf.getInt();
            this.timescale = buf.getInt();
            this.duration = buf.getInt();
        }
        this.rate = buf.getInt();
        this.volume = buf.getShort();
        this.reserved1 = buf.getShort();
        IO.get(buf, this.reserved2);
        IO.get(buf, this.matrix);
        IO.get(buf, this.pre_defined);
        this.next_track_ID = buf.getInt();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.version == 1) {
            buf.putLong(this.creation_time);
            buf.putLong(this.modification_time);
            buf.putInt(this.timescale);
            buf.putLong(this.duration);
        } else {
            buf.putInt((int)this.creation_time);
            buf.putInt((int)this.modification_time);
            buf.putInt(this.timescale);
            buf.putInt((int)this.duration);
        }
        buf.putInt(this.rate);
        buf.putShort(this.volume);
        buf.putShort(this.reserved1);
        IO.put(buf, this.reserved2);
        IO.put(buf, this.matrix);
        IO.put(buf, this.pre_defined);
        buf.putInt(this.next_track_ID);
        IO.write(ch, (this.version == 1 ? 28 : 16) + 80, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 80L;
        s = this.version == 1 ? (s += 28L) : (s += 16L);
        this.length(s);
    }
}

