/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class FileTypeBox
extends Box {
    protected int major_brand;
    protected int minor_version;
    protected int[] compatible_brands;

    FileTypeBox() {
        super(ftyp);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        IO.read(ch, (int)this.length(), buf);
        this.major_brand = buf.getInt();
        this.minor_version = buf.getInt();
        this.compatible_brands = new int[buf.remaining() / 4];
        IO.get(buf, this.compatible_brands);
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        buf.putInt(this.major_brand);
        buf.putInt(this.minor_version);
        IO.put(buf, this.compatible_brands);
        IO.write(ch, buf.position(), buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        this.length(s += (long)(this.compatible_brands.length * 4));
    }
}

