/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AppleDataBox;
import com.frostwire.mp4.Bits;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AppleIntegerBox
extends AppleDataBox {
    private byte[] value;

    AppleIntegerBox(int type) {
        super(type);
        this.dataType = 15;
    }

    public int value() {
        if (this.value != null) {
            ByteBuffer t = ByteBuffer.allocate(4);
            t.put(this.value);
            t.flip();
            return t.getInt();
        }
        return 0;
    }

    public void value(int value) {
        this.value = value <= 127 && value > -128 ? new byte[]{Bits.int0(value)} : (value <= Short.MAX_VALUE && value > Short.MIN_VALUE ? new byte[]{Bits.int1(value), Bits.int0(value)} : (value <= 0x7FFFFF && value > -838860 ? new byte[]{Bits.int2(value), Bits.int1(value), Bits.int0(value)} : new byte[]{Bits.int3(value), Bits.int2(value), Bits.int1(value), Bits.int0(value)}));
        this.dataLength = this.value.length + 16;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 16L);
        if (len != 0) {
            IO.read(ch, len, buf);
            this.value = new byte[len];
            buf.get(this.value);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.value != null) {
            buf.put(this.value);
            IO.write(ch, this.value.length, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 16L;
        if (this.value != null) {
            s += (long)this.value.length;
        }
        this.length(s);
    }
}

