/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2Tag;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NoSuchTagException;
import com.frostwire.mp3.UnsupportedTagException;

public class ID3v22Tag
extends AbstractID3v2Tag {
    public static final String VERSION = "2.0";

    public ID3v22Tag() {
        this.version = VERSION;
    }

    public ID3v22Tag(byte[] buffer) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        super(buffer);
    }

    public ID3v22Tag(byte[] buffer, boolean obseleteFormat) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        super(buffer, obseleteFormat);
    }

    @Override
    protected void unpackFlags(byte[] bytes) {
        this.unsynchronisation = BufferTools.checkBit(bytes[5], 7);
        this.compression = BufferTools.checkBit(bytes[5], 6);
    }

    @Override
    protected void packFlags(byte[] bytes, int offset) {
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 7, this.unsynchronisation);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 6, this.compression);
    }
}

