/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.byte_vectors_pair;
import com.frostwire.jlibtorrent.swig.libtorrent;

public final class Ed25519 {
    public static final int SEED_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 64;
    public static final int SIGNATURE_SIZE = 64;
    public static final int SCALAR_SIZE = 32;
    public static final int SHARED_SECRET_SIZE = 32;

    private Ed25519() {
    }

    public static byte[] createSeed() {
        byte_vector seed = libtorrent.ed25519_create_seed();
        return Vectors.byte_vector2bytes(seed);
    }

    public static Pair<byte[], byte[]> createKeypair(byte[] seed) {
        if (seed == null || seed.length != 32) {
            throw new IllegalArgumentException("seed must be not null and of size 32");
        }
        byte_vectors_pair keypair = libtorrent.ed25519_create_keypair(Vectors.bytes2byte_vector(seed));
        return new Pair<byte[], byte[]>(Vectors.byte_vector2bytes(keypair.getFirst()), Vectors.byte_vector2bytes(keypair.getSecond()));
    }

    public static byte[] sign(byte[] message, byte[] publicKey, byte[] secretKey) {
        if (publicKey == null || publicKey.length != 32) {
            throw new IllegalArgumentException("public key must be not null and of size 32");
        }
        if (secretKey == null || secretKey.length != 64) {
            throw new IllegalArgumentException("secret key must be not null and of size 64");
        }
        byte_vector signature = libtorrent.ed25519_sign(Vectors.bytes2byte_vector(message), Vectors.bytes2byte_vector(publicKey), Vectors.bytes2byte_vector(secretKey));
        return Vectors.byte_vector2bytes(signature);
    }

    public static boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        if (signature == null || signature.length != 64) {
            throw new IllegalArgumentException("signature must be not null and of size 64");
        }
        if (publicKey == null || publicKey.length != 32) {
            throw new IllegalArgumentException("public key must be not null and of size 32");
        }
        return libtorrent.ed25519_verify(Vectors.bytes2byte_vector(signature), Vectors.bytes2byte_vector(message), Vectors.bytes2byte_vector(publicKey));
    }

    public static byte[] addScalarPublic(byte[] publicKey, byte[] scalar) {
        if (publicKey == null || publicKey.length != 32) {
            throw new IllegalArgumentException("public key must be not null and of size 32");
        }
        if (scalar == null || scalar.length != 32) {
            throw new IllegalArgumentException("scalar must be not null and of size 32");
        }
        byte_vector ret = libtorrent.ed25519_add_scalar_public(Vectors.bytes2byte_vector(publicKey), Vectors.bytes2byte_vector(scalar));
        return Vectors.byte_vector2bytes(ret);
    }

    public static byte[] addScalarSecret(byte[] secretKey, byte[] scalar) {
        if (secretKey == null || secretKey.length != 64) {
            throw new IllegalArgumentException("public key must be not null and of size 64");
        }
        if (scalar == null || scalar.length != 32) {
            throw new IllegalArgumentException("scalar must be not null and of size 32");
        }
        byte_vector ret = libtorrent.ed25519_add_scalar_secret(Vectors.bytes2byte_vector(secretKey), Vectors.bytes2byte_vector(scalar));
        return Vectors.byte_vector2bytes(ret);
    }

    public byte[] keyExchange(byte[] publicKey, byte[] secretKey) {
        if (publicKey == null || publicKey.length != 32) {
            throw new IllegalArgumentException("public key must be not null and of size 32");
        }
        if (secretKey == null || secretKey.length != 64) {
            throw new IllegalArgumentException("private key must be not null and of size 64");
        }
        byte_vector secret = libtorrent.ed25519_key_exchange(Vectors.bytes2byte_vector(publicKey), Vectors.bytes2byte_vector(secretKey));
        return Vectors.byte_vector2bytes(secret);
    }
}

