/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.InstallerUpdater;
import com.frostwire.gui.updates.UpdateManager;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.OSUtils;

public final class UpdateMediator {
    private static final Logger LOG = Logger.getLogger(UpdateMediator.class);
    private UpdateMessage latestMsg;
    private static UpdateMediator instance;

    public static UpdateMediator instance() {
        if (instance == null) {
            instance = new UpdateMediator();
        }
        return instance;
    }

    private UpdateMediator() {
    }

    public boolean isUpdated() {
        return this.latestMsg != null && this.latestMsg.getVersion() != null && !this.latestMsg.getVersion().trim().equals("") && !UpdateManager.isFrostWireOld(this.latestMsg);
    }

    public String getLatestVersion() {
        return this.latestMsg != null ? this.latestMsg.getVersion() : "";
    }

    public boolean isUpdateDownloading() {
        return InstallerUpdater.isDownloadingUpdate();
    }

    public boolean isUpdateDownloaded() {
        if (this.latestMsg == null) {
            return false;
        }
        String lastMD5 = InstallerUpdater.getLastMD5();
        return lastMD5 != null && lastMD5.equalsIgnoreCase(this.latestMsg.getRemoteMD5().trim());
    }

    private File getUpdateBinaryFile() {
        try {
            if (this.latestMsg == null) {
                return null;
            }
            String installerFilename = UpdateMediator.getInstallerFilename(this.latestMsg);
            if (installerFilename == null) {
                return null;
            }
            File f = new File(UpdateSettings.UPDATES_DIR, installerFilename);
            if (!f.exists()) {
                return null;
            }
            return f;
        }
        catch (Throwable e) {
            LOG.error("Error getting update binary path", e);
            return null;
        }
    }

    static String getInstallerFilename(UpdateMessage message) {
        String installerFilename = null;
        if (message.getTorrent() != null) {
            int index1 = message.getTorrent().lastIndexOf(47) + 1;
            int index2 = message.getTorrent().lastIndexOf(".torrent");
            installerFilename = message.getTorrent().substring(index1, index2);
        } else if (message.getInstallerUrl() != null) {
            int index1 = message.getInstallerUrl().lastIndexOf(47) + 1;
            installerFilename = message.getInstallerUrl().substring(index1);
        }
        return installerFilename;
    }

    public void startUpdate() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                File executableFile = UpdateMediator.this.getUpdateBinaryFile();
                if (executableFile == null || UpdateMediator.this.latestMsg == null) {
                    return;
                }
                UpdateMediator.openInstallerAndShutdown(executableFile);
            }
        });
    }

    static void openInstallerAndShutdown(File executableFile) {
        try {
            if (OSUtils.isWindows()) {
                String[] commands = new String[]{"CMD.EXE", "/C", executableFile.getAbsolutePath()};
                ProcessBuilder pbuilder = new ProcessBuilder(commands);
                pbuilder.start();
            } else if (OSUtils.isLinux() && OSUtils.isUbuntu()) {
                UpdateMediator.installUbuntu(executableFile);
            } else if (OSUtils.isMacOSX()) {
                String[] mountCommand = new String[]{"hdiutil", "attach", executableFile.getAbsolutePath()};
                String[] finderShowCommand = new String[]{"open", "/Volumes/" + FilenameUtils.getBaseName(executableFile.getName())};
                String[] finderShowCommandFallback = new String[]{"open", "file:///Volumes/Frostwire"};
                String[] finderShowCommandFallback2 = new String[]{"open", "file:///Volumes/Frostwire Installer"};
                ProcessBuilder pbuilder = new ProcessBuilder(mountCommand);
                Process mountingProcess = pbuilder.start();
                mountingProcess.waitFor();
                pbuilder = new ProcessBuilder(finderShowCommand);
                Process showProcess = pbuilder.start();
                showProcess.waitFor();
                pbuilder = new ProcessBuilder(finderShowCommandFallback);
                showProcess = pbuilder.start();
                showProcess.waitFor();
                pbuilder = new ProcessBuilder(finderShowCommandFallback2);
                showProcess = pbuilder.start();
                showProcess.waitFor();
                Runtime.getRuntime().exec(finderShowCommandFallback);
            }
            GUIMediator.shutdown();
        }
        catch (Throwable e) {
            LOG.error("Unable to launch new installer", e);
        }
    }

    public void checkForUpdate() {
        this.latestMsg = null;
        UpdateManager.scheduleUpdateCheckTask(0, true);
    }

    void setUpdateMessage(UpdateMessage msg) {
        this.latestMsg = msg;
    }

    public void showUpdateMessage() {
        if (this.latestMsg == null) {
            return;
        }
        DialogOption result = GUIMediator.showYesNoMessage(this.latestMsg.getMessageInstallerReady(), I18n.tr("Update"), 1);
        if (result == DialogOption.YES) {
            this.startUpdate();
        }
    }

    private static void installUbuntu(File executableFile) throws IOException {
        boolean success;
        boolean bl = success = UpdateMediator.tryGnomeSoftware(executableFile) || UpdateMediator.tryGdebiGtk(executableFile) || UpdateMediator.trySoftwareCenter(executableFile);
        if (!success) {
            throw new IOException("Unable to install update");
        }
    }

    private static boolean tryGnomeSoftware(File executableFile) {
        return UpdateMediator.tryUbuntuInstallCmd("/usr/bin/gnome-software", "--local-filename=" + executableFile.getAbsolutePath(), "--verbose");
    }

    private static boolean tryGdebiGtk(File executableFile) {
        return UpdateMediator.tryUbuntuInstallCmd("gdebi-gtk", executableFile);
    }

    private static boolean trySoftwareCenter(File executableFile) {
        return UpdateMediator.tryUbuntuInstallCmd("/usr/bin/software-center", executableFile);
    }

    private static boolean tryUbuntuInstallCmd(String cmd, File executableFile) {
        return UpdateMediator.tryUbuntuInstallCmd(cmd, executableFile.getAbsolutePath());
    }

    private static boolean tryUbuntuInstallCmd(String cmd, String ... options) {
        try {
            int options_length = options == null || options.length == 0 ? 0 : options.length;
            String[] commands = new String[1 + options_length];
            commands[0] = cmd;
            if (options != null) {
                System.arraycopy(options, 0, commands, 1, options_length);
            }
            System.out.print("UpdateMediator.tryUbuntuInstallCmd: ");
            for (String c : commands) {
                System.out.print(c + " ");
            }
            System.out.println();
            ProcessBuilder pbuilder = new ProcessBuilder(commands);
            pbuilder.start();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getUpdateDownloadProgress() {
        return InstallerUpdater.getUpdateDownloadProgress();
    }
}

