/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public final class SkinSliderThumbPainter
extends AbstractSkinPainter {
    private final Image image;

    public SkinSliderThumbPainter(State state) {
        this.image = this.getImage(this.getImageName(state));
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        g.drawImage(this.image, 0, 0, null);
    }

    private String getImageName(State state) {
        String imageName = null;
        switch (state) {
            case Disabled: {
                imageName = "slider_inactive";
                break;
            }
            case Focused: 
            case Enabled: {
                imageName = "slider_active";
                break;
            }
            case FocusedMouseOver: 
            case MouseOver: 
            case FocusedPressed: 
            case Pressed: {
                imageName = "slider_pressed";
                break;
            }
            default: {
                throw new RuntimeException("Not supported state");
            }
        }
        return imageName;
    }

    public static enum State {
        Disabled,
        Enabled,
        FocusedMouseOver,
        FocusedPressed,
        Focused,
        MouseOver,
        Pressed;

    }
}

