/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;

public class SkinComboPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -3629162645341440812L;

    public SkinComboPopup(JComboBox<Object> combo) {
        super(combo);
        this.setOpaque(true);
        this.list.setBackground(combo.getBackground());
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return new Point(popupLocation.x, popupLocation.y);
    }

    @Override
    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
    }

    public JComboBox<Object> getCombobox() {
        return this.comboBox;
    }
}

