/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrieSet;
import org.limewire.util.OSUtils;

public class SearchField
extends JXSearchField {
    private static JPopupMenu POPUP;
    private UndoManager undoManager;
    private static Action UNDO_ACTION;
    private static Action CUT_ACTION;
    private static Action COPY_ACTION;
    private static Action PASTE_ACTION;
    private static Action DELETE_ACTION;
    private static Action SELECT_ALL_ACTION;
    protected AutoCompleteDictionary dict;
    protected AutoCompleteList entryList;
    protected JPanel entryPanel;
    protected Popup popup;
    protected boolean showPending;

    public SearchField() {
        this.init();
    }

    public void undo() {
        try {
            if (this.undoManager != null) {
                this.undoManager.undoOrRedo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void setUndoManager(UndoManager undoer) {
        this.undoManager = undoer;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setDocument(Document doc) {
        if (doc != this.getDocument()) {
            this.undoManager = null;
        }
        super.setDocument(doc);
    }

    private void init() {
        this.setComponentPopupMenu(SearchField.createPopup());
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.enableEvents(8L);
        this.enableEvents(32768L);
        this.enableEvents(4L);
        ThemeMediator.fixKeyStrokes(this);
    }

    private static JPopupMenu createPopup() {
        if (POPUP != null) {
            return POPUP;
        }
        POPUP = new SkinPopupMenu(){
            private static final long serialVersionUID = -6004124495511263059L;

            @Override
            public void show(Component invoker, int x, int y) {
                ((SearchField)invoker).updateActions();
                super.show(invoker, x, y);
            }
        };
        POPUP.add(new SkinMenuItem(UNDO_ACTION));
        POPUP.addSeparator();
        POPUP.add(new SkinMenuItem(CUT_ACTION));
        POPUP.add(new SkinMenuItem(COPY_ACTION));
        POPUP.add(new SkinMenuItem(PASTE_ACTION));
        POPUP.add(new SkinMenuItem(DELETE_ACTION));
        POPUP.addSeparator();
        POPUP.add(new SkinMenuItem(SELECT_ALL_ACTION));
        return POPUP;
    }

    private void updateActions() {
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        boolean stuffSelected = !selectedText.equals("");
        boolean allSelected = selectedText.equals(this.getText());
        UNDO_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isUndoAvailable());
        CUT_ACTION.setEnabled(this.isEnabled() && this.isEditable() && stuffSelected);
        COPY_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        PASTE_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isPasteAvailable());
        DELETE_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        SELECT_ALL_ACTION.setEnabled(this.isEnabled() && !allSelected);
    }

    private boolean isUndoAvailable() {
        return this.getUndoManager() != null && this.getUndoManager().canUndoOrRedo();
    }

    private boolean isPasteAvailable() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (UnsupportedOperationException he) {
            return false;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    public void setDictionary(AutoCompleteDictionary dict) {
        if (this.dict == null) {
            this.setUp();
        }
        this.dict = dict;
    }

    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public AutoCompleteDictionary createDefaultDictionary() {
        return new StringTrieSet(true);
    }

    public void setAutoComplete(boolean val) {
        UISettings.AUTOCOMPLETE_ENABLED.setValue(val);
    }

    public boolean getAutoComplete() {
        return UISettings.AUTOCOMPLETE_ENABLED.getValue();
    }

    public void addToDictionary() {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(this.getText().trim());
    }

    public void addToDictionary(String s) {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(s.trim());
    }

    protected String lookup(String s) {
        if (this.dict != null && this.getAutoComplete() && !s.equals("")) {
            return this.dict.lookup(s);
        }
        return null;
    }

    @Override
    protected void fireActionPerformed() {
        String selection;
        if (this.popup != null && (selection = (String)this.entryList.getSelectedValue()) != null) {
            this.hidePopup();
            this.setText(selection);
            return;
        }
        super.fireActionPerformed();
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
            evt.consume();
        }
        super.processKeyEvent(evt);
        if (this.dict != null) {
            block0 : switch (evt.getID()) {
                case 401: {
                    switch (evt.getKeyCode()) {
                        case 38: {
                            if (this.popup != null) {
                                this.entryList.decrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 40: {
                            if (this.popup != null) {
                                this.entryList.incrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 27: {
                            if (this.popup == null) break;
                            this.hidePopup();
                            this.selectAll();
                        }
                    }
                    break;
                }
                case 400: {
                    switch (evt.getKeyChar()) {
                        case '\n': {
                            break block0;
                        }
                    }
                    this.autoCompleteInput();
                }
            }
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent evt) {
        super.processHierarchyEvent(evt);
        if ((evt.getChangeFlags() & 4L) == 4L) {
            boolean showing = this.isShowing();
            if (!showing && this.popup != null) {
                this.hidePopup();
            } else if (showing && this.popup == null && this.showPending) {
                this.autoCompleteInput();
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
        if (evt.getID() == 1005 && this.popup != null) {
            this.hidePopup();
        }
    }

    protected void setUp() {
    }

    protected JComponent getPopupComponent() {
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        this.entryList = new AutoCompleteList();
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, c);
        this.entryPanel.add((Component)new ClearHistory(), c);
        return this.entryPanel;
    }

    protected void showPopup(Iterator<String> iter) {
        this.getPopupComponent();
        boolean different = false;
        Vector<String> v = new Vector<String>();
        ListModel model = this.entryList.getModel();
        int i = 0;
        while (iter.hasNext()) {
            String next = iter.next();
            v.add(next);
            if (!different && i < model.getSize()) {
                different |= !next.equals(model.getElementAt(i));
            }
            ++i;
        }
        if (different |= model.getSize() != v.size()) {
            this.entryList.setListData(v);
            this.entryList.clearSelection();
        }
        this.entryList.setCurrentText(this.getText());
        this.showPopup();
    }

    public void showPopup() {
        if (this.popup == null && this.entryList.getModel().getSize() > 0) {
            if (this.isShowing()) {
                Point origin = this.getLocationOnScreen();
                PopupFactory pf = PopupFactory.getSharedInstance();
                JComponent parent = this;
                if (OSUtils.isMacOSX()) {
                    parent = new JPanel();
                    new MyPopup(this, parent, 0, 0);
                }
                this.popup = pf.getPopup(parent, this.getPopupComponent(), origin.x, origin.y + this.getHeight() + 1);
                this.showPending = false;
                this.popup.show();
            } else {
                this.showPending = true;
            }
        }
    }

    public void hidePopup() {
        this.showPending = false;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void autoCompleteInput() {
        String input = this.getText();
        if (input != null && input.length() > 0) {
            Iterator<String> it = this.dict.iterator(input);
            if (it.hasNext()) {
                this.showPopup(it);
            } else {
                this.hidePopup();
            }
        } else {
            this.hidePopup();
        }
    }

    static {
        UNDO_ACTION = new FieldAction(I18n.tr("Undo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).undo();
            }
        };
        CUT_ACTION = new FieldAction(I18n.tr("Cut")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).cut();
            }
        };
        COPY_ACTION = new FieldAction(I18n.tr("Copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).copy();
            }
        };
        PASTE_ACTION = new FieldAction(I18n.tr("Paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).paste();
            }
        };
        DELETE_ACTION = new FieldAction(I18n.tr("Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).replaceSelection("");
            }
        };
        SELECT_ALL_ACTION = new FieldAction(I18n.tr("Select All")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.getField(e).selectAll();
            }
        };
    }

    private static class MyPopup
    extends Popup {
        public MyPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
        }
    }

    protected class AutoCompleteList
    extends JList<String> {
        private static final long serialVersionUID = -7324769835640667828L;
        private String currentText;

        public AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
            if (OSUtils.isWindows()) {
                this.setFont(ThemeMediator.DIALOG_FONT);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            int idx;
            super.processMouseEvent(me);
            if (me.getID() == 500 && (idx = this.locationToIndex(me.getPoint())) != -1 && this.isSelectedIndex(idx)) {
                String selection = (String)this.getSelectedValue();
                SearchField.this.setText(selection);
                SearchField.this.hidePopup();
            }
        }

        void setCurrentText(String text) {
            this.currentText = text;
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                SearchField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex() + 1;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                SearchField.this.setText((String)this.getSelectedValue());
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                SearchField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex();
                selectedIndex = selectedIndex == -1 ? this.getModel().getSize() - 1 : --selectedIndex;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                SearchField.this.setText((String)this.getSelectedValue());
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            int width = SearchField.this.getSize().width - 2;
            int rows = Math.min(this.getModel().getSize(), 8);
            int height = rows * this.getCellBounds((int)0, (int)0).height;
            return new Dimension(width, height);
        }
    }

    private class ClearHistory
    extends JButton {
        private static final long serialVersionUID = 601999394867955024L;

        ClearHistory() {
            super(I18n.tr("Clear History"));
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (me.getID() == 500) {
                SearchField.this.dict.clear();
                SearchField.this.hidePopup();
            }
        }
    }

    private static abstract class FieldAction
    extends AbstractAction {
        public FieldAction(String name) {
            super(I18n.tr(name));
        }

        protected SearchField getField(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            JPopupMenu menu = (JPopupMenu)source.getParent();
            return (SearchField)menu.getInvoker();
        }
    }
}

