/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.LibraryUtils;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.PlaylistItemDB;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.searchfield.SearchField;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.LibrarySettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileFilter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

public class LibrarySearch
extends JPanel {
    private JLabel statusLabel;
    private SearchField searchField;
    private SearchRunnable currentSearchRunnable;
    private int resultsCount;
    private String status;

    public LibrarySearch() {
        this.setupUI();
    }

    public void searchFor(final String query, final boolean displayTextOnSearchBox) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
                LibraryMediator.instance().getLibraryExplorer().selectFinishedDownloads();
                if (LibrarySearch.this.searchField != null) {
                    SearchLibraryAction searchAction = new SearchLibraryAction();
                    if (displayTextOnSearchBox) {
                        if (query.length() < 50) {
                            LibrarySearch.this.searchField.setText(query);
                        } else {
                            LibrarySearch.this.searchField.setText(query.substring(0, 49));
                        }
                        searchAction.actionPerformed(null);
                    } else {
                        searchAction.actionPerformed(null, query);
                    }
                }
            }
        });
    }

    public void addResults(int n) {
        if (n < 0) {
            return;
        }
        this.resultsCount += n;
        this.setStatus(this.resultsCount + " " + I18n.tr("search results"));
    }

    public void clear() {
        this.setStatus("");
        this.searchField.setText("");
        this.resultsCount = 0;
    }

    void pushStatus(final String newStatus) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibrarySearch.this.statusLabel.setText(newStatus);
            }
        });
    }

    void revertStatus() {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibrarySearch.this.statusLabel.setText(LibrarySearch.this.status);
            }
        });
    }

    public void setStatus(String status) {
        this.status = status;
        this.statusLabel.setText(status);
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setMinimumSize(new Dimension(200, 20));
        this.setPreferredSize(new Dimension(200, 20));
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 0));
        this.add((Component)this.statusLabel, "Center");
        this.searchField = new SearchField();
        this.searchField.setSearchMode(JXSearchField.SearchMode.INSTANT);
        this.searchField.setInstantSearchDelay(50);
        this.searchField.setPrompt(I18n.tr("Search in Library"));
        Font origFont = this.searchField.getFont();
        Font newFont = origFont.deriveFont(origFont.getSize2D() + 2.0f);
        this.searchField.setFont(newFont);
        this.searchField.addActionListener(new ActionListener(){
            private SearchLibraryAction a;
            {
                this.a = new SearchLibraryAction();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LibrarySearch.this.searchField.getText().length() == 0) {
                    this.a.perform(".");
                } else {
                    this.a.actionPerformed(null);
                }
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder() == null && LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist() == null) {
                    LibraryMediator.instance().getLibraryExplorer().selectAudio();
                }
            }
        });
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public void setSearchPrompt(String string) {
        this.searchField.setPrompt(string);
    }

    private final class SearchPlaylistItemsRunnable
    extends SearchRunnable {
        private final String query;
        private final Playlist playlist;

        public SearchPlaylistItemsRunnable(String query, Playlist playlist) {
            this.query = query;
            this.playlist = playlist;
            this.canceled = false;
            if (playlist == null) {
                this.canceled = true;
            }
        }

        @Override
        public void run() {
            try {
                if (this.canceled) {
                    return;
                }
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LibraryPlaylistsTableMediator.instance().clearTable();
                        LibrarySearch.this.setStatus("");
                        LibrarySearch.this.statusLabel.setText("");
                        LibrarySearch.this.resultsCount = 0;
                    }
                });
                this.search();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void search() {
            if (this.canceled || this.playlist == null) {
                return;
            }
            String sql = null;
            List<List<Object>> rows = null;
            if (StringUtils.isNullOrEmpty(this.query, true) || this.query.equals(".")) {
                if (this.playlist.isStarred()) {
                    LibraryMediator.instance().getLibraryExplorer().selectStarred();
                } else {
                    LibraryMediator.instance().getLibraryPlaylists().selectPlaylist(this.playlist);
                }
                return;
            }
            String luceneQuery = LibraryUtils.wildcardLuceneQuery(this.query);
            if (!this.playlist.isStarred()) {
                sql = "SELECT T.playlistItemId, T.filePath, T.fileName, T.fileSize, T.fileExtension, T.trackTitle, T.trackDurationInSecs, T.trackArtist, T.trackAlbum, T.coverArtPath, T.trackBitrate, T.trackComment, T.trackGenre, T.trackNumber, T.trackYear, T.starred, T.sortIndex FROM FTL_SEARCH_DATA(?, 0, 0) FT, PLAYLISTITEMS T WHERE FT.TABLE='PLAYLISTITEMS' AND T.playlistItemId = FT.KEYS[0] AND T.playlistId = ?";
                rows = LibraryMediator.getLibrary().getLibraryDatabase().query(sql, luceneQuery, this.playlist.getId());
            } else {
                sql = "SELECT T.playlistItemId, T.filePath, T.fileName, T.fileSize, T.fileExtension, T.trackTitle, T.trackDurationInSecs, T.trackArtist, T.trackAlbum, T.coverArtPath, T.trackBitrate, T.trackComment, T.trackGenre, T.trackNumber, T.trackYear, T.starred FROM FTL_SEARCH_DATA(?, 1000, 0) FT, PLAYLISTITEMS T WHERE FT.TABLE='PLAYLISTITEMS' AND T.playlistItemId = FT.KEYS[0] AND T.starred = TRUE";
                rows = LibraryMediator.getLibrary().getLibraryDatabase().query(sql, luceneQuery);
            }
            final ArrayList<PlaylistItem> results = new ArrayList<PlaylistItem>();
            for (List<Object> row : rows) {
                if (this.canceled) {
                    return;
                }
                Playlist currentPlaylist = LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
                if (!this.playlist.isStarred() && !this.playlist.equals(currentPlaylist)) {
                    return;
                }
                PlaylistItem item = new PlaylistItem(currentPlaylist);
                PlaylistItemDB.fill(row, item);
                results.add(item);
                if (results.size() <= 100) continue;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LibraryMediator.instance().addItemsToLibraryTable(results);
                        results.clear();
                    }
                };
                GUIMediator.safeInvokeLater(r);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addItemsToLibraryTable(results);
                }
            };
            GUIMediator.safeInvokeLater(r);
        }
    }

    private static final class SearchFileFilter
    implements FileFilter {
        private final String[] _tokens;

        public SearchFileFilter(String query) {
            this._tokens = StringUtils.removeDoubleSpaces(this.normalize(query)).split(" ");
        }

        @Override
        public boolean accept(File pathname) {
            return this.accept(pathname, true);
        }

        public boolean accept(File pathname, boolean includeAllDirectories) {
            if (!pathname.exists()) {
                return false;
            }
            if (pathname.isDirectory() && includeAllDirectories) {
                return true;
            }
            String name = this.normalize(pathname.getAbsolutePath());
            for (String token : this._tokens) {
                if (name.contains(token)) continue;
                return false;
            }
            return true;
        }

        private String normalize(String token) {
            String norm = Normalizer.normalize(token, Normalizer.Form.NFKD);
            norm = norm.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
            norm = norm.toLowerCase(Locale.US);
            return norm;
        }
    }

    private final class SearchFilesRunnable
    extends SearchRunnable {
        private final String _query;
        private final DirectoryHolder directoryHolder;

        public SearchFilesRunnable(String query) {
            this._query = query;
            this.directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
            this.canceled = false;
            if (this.directoryHolder == null) {
                this.canceled = true;
            }
        }

        @Override
        public void run() {
            try {
                ArrayList<File> cache;
                if (this.canceled) {
                    return;
                }
                if (this._query.equals(".") && this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryMediator.instance().updateTableFiles(SearchFilesRunnable.this.directoryHolder);
                            LibrarySearch.this.setStatus("");
                            LibrarySearch.this.resultsCount = 0;
                        }
                    });
                    return;
                }
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LibraryFilesTableMediator.instance().clearTable();
                        LibrarySearch.this.statusLabel.setText("");
                        LibrarySearch.this.resultsCount = 0;
                    }
                });
                if (this.directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
                    cache = new ArrayList<File>(((MediaTypeSavedFilesDirectoryHolder)this.directoryHolder).getCache());
                    if (cache.size() > 0) {
                        this.search(cache);
                        return;
                    }
                } else if (this.directoryHolder instanceof SavedFilesDirectoryHolder && (cache = new ArrayList<File>(((SavedFilesDirectoryHolder)this.directoryHolder).getCache())).size() > 0) {
                    this.search(cache);
                    return;
                }
                Set<File> ignore = TorrentUtil.getIgnorableFiles();
                if (this.directoryHolder instanceof TorrentDirectoryHolder) {
                    this.search(((TorrentDirectoryHolder)this.directoryHolder).getDirectory(), ignore, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                    return;
                }
                if (this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                    this.search(((SavedFilesDirectoryHolder)this.directoryHolder).getDirectory(), ignore, LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                    return;
                }
                HashSet<File> directories = new HashSet<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
                directories.removeAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                for (File dir : directories) {
                    if (dir == null || dir.equals(LibrarySettings.USER_MUSIC_FOLDER.getValue()) && this.directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder && !((MediaTypeSavedFilesDirectoryHolder)this.directoryHolder).getMediaType().equals(MediaType.getAudioMediaType())) continue;
                    this.search(dir, new HashSet<File>(), LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private void search(File haystackDir, Set<File> excludeFiles, Set<File> exludedSubFolders) {
            if (this.canceled) {
                return;
            }
            if (haystackDir == null || !haystackDir.isDirectory() || !haystackDir.exists()) {
                return;
            }
            ArrayList<File> directories = new ArrayList<File>();
            final ArrayList<File> results = new ArrayList<File>();
            SearchFileFilter searchFilter = new SearchFileFilter(this._query);
            for (File child : FileUtils.listFiles(haystackDir)) {
                if (this.canceled) {
                    return;
                }
                DirectoryHolder currentDirectoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                if (!this.directoryHolder.equals(currentDirectoryHolder)) {
                    return;
                }
                if (excludeFiles.contains(child) || child.isHidden()) continue;
                if (child.isDirectory() && !exludedSubFolders.contains(child)) {
                    directories.add(child);
                    continue;
                }
                if (!child.isFile()) continue;
                if (this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                    if (!searchFilter.accept(child, false)) continue;
                    results.add(child);
                    continue;
                }
                if (!this.directoryHolder.accept(child)) continue;
                results.add(child);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addFilesToLibraryTable(results);
                    if (SearchFilesRunnable.this.directoryHolder instanceof SavedFilesDirectoryHolder) {
                        LibraryFilesTableMediator.instance().resetAudioPlayerFileView();
                    }
                }
            };
            GUIMediator.safeInvokeLater(r);
            for (File directory : directories) {
                this.search(directory, excludeFiles, exludedSubFolders);
            }
        }

        private void search(List<File> cache) {
            if (this.canceled) {
                return;
            }
            final ArrayList<File> results = new ArrayList<File>();
            SearchFileFilter searchFilter = new SearchFileFilter(this._query);
            for (File file : cache) {
                if (this.canceled) {
                    return;
                }
                DirectoryHolder currentDirectoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
                if (!this.directoryHolder.equals(currentDirectoryHolder)) {
                    return;
                }
                if (file.isHidden() || !searchFilter.accept(file)) continue;
                results.add(file);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    LibraryMediator.instance().addFilesToLibraryTable(results);
                }
            };
            GUIMediator.safeInvokeLater(r);
        }
    }

    private abstract class SearchRunnable
    implements Runnable {
        protected boolean canceled;

        private SearchRunnable() {
        }

        public void cancel() {
            this.canceled = true;
        }
    }

    private class SearchLibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = -2182314529781104010L;

        public SearchLibraryAction() {
            this.putValue("Name", I18n.tr("Search"));
        }

        public boolean validate(SearchInformation info) {
            switch (SearchMediator.validateInfo(info)) {
                case 1: {
                    return false;
                }
            }
            return true;
        }

        public void perform(String query) {
            DirectoryHolder directoryHolder;
            if (query.length() == 0) {
                LibrarySearch.this.searchField.getToolkit().beep();
                return;
            }
            SearchInformation info = SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType());
            if (!this.validate(info)) {
                return;
            }
            LibrarySearch.this.searchField.addToDictionary();
            if (LibrarySearch.this.currentSearchRunnable != null) {
                LibrarySearch.this.currentSearchRunnable.cancel();
            }
            if ((directoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder()) != null && !(directoryHolder instanceof StarredDirectoryHolder)) {
                LibrarySearch.this.currentSearchRunnable = new SearchFilesRunnable(query);
                BackgroundExecutorService.schedule(LibrarySearch.this.currentSearchRunnable);
            }
            Playlist playlist = null;
            playlist = directoryHolder instanceof StarredDirectoryHolder ? LibraryMediator.getLibrary().getStarredPlaylist() : LibraryMediator.instance().getLibraryPlaylists().getSelectedPlaylist();
            if (playlist != null) {
                LibrarySearch.this.currentSearchRunnable = new SearchPlaylistItemsRunnable(query, playlist);
                BackgroundExecutorService.schedule(LibrarySearch.this.currentSearchRunnable);
            }
        }

        public void actionPerformed(ActionEvent e, String query) {
            this.perform(query);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionPerformed(e, LibrarySearch.this.searchField.getText().trim());
        }
    }
}

