/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

class LibraryPlaylistsTransferHandler
extends TransferHandler {
    private final JList<Object> list;

    LibraryPlaylistsTransferHandler(JList<Object> list) {
        this.list = list;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return DNDUtils.supportCanImport(LibraryPlaylistsTableTransferable.ITEM_ARRAY, support, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        TransferHandler.DropLocation location = support.getDropLocation();
        int index = this.list.locationToIndex(location.getDropPoint());
        if (index == -1) return false;
        Playlist playlist = this.getTargetPlaylist(location, index);
        if (playlist == null) {
            if (this.createNewPlaylist(support)) {
                return false;
            }
        } else {
            try {
                Transferable transferable = support.getTransferable();
                DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
                if (DNDUtils.contains(dataFlavors, LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                    PlaylistItem[] playlistItems = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.PlaylistItemContainer)transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                    LibraryUtils.asyncAddToPlaylist(playlist, playlistItems);
                }
                File[] files = DNDUtils.getFiles(support.getTransferable());
                if (files.length == 1 && files[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.asyncAddToPlaylist(playlist, files[0]);
                }
                LibraryUtils.asyncAddToPlaylist(playlist, files);
            }
            finally {
                return false;
            }
        }
    }

    private Playlist getTargetPlaylist(TransferHandler.DropLocation location, int index) {
        Rectangle rect = this.list.getUI().getCellBounds(this.list, index, index);
        if (!rect.contains(location.getDropPoint())) {
            index = 0;
        }
        LibraryPlaylists.LibraryPlaylistsListCell cell = (LibraryPlaylists.LibraryPlaylistsListCell)this.list.getModel().getElementAt(index);
        return cell.getPlaylist();
    }

    private boolean createNewPlaylist(TransferHandler.TransferSupport support) {
        try {
            Transferable transferable = support.getTransferable();
            if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                Object transferData = transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY);
                PlaylistItem[] playlistItems = null;
                if (transferData instanceof LibraryPlaylistsTableTransferable.Item[]) {
                    playlistItems = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferData);
                } else if (transferData instanceof LibraryPlaylistsTableTransferable.PlaylistItemContainer) {
                    playlistItems = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.PlaylistItemContainer)transferData);
                }
                if (playlistItems != null) {
                    LibraryUtils.createNewPlaylist(playlistItems);
                }
            } else {
                File[] files = DNDUtils.getFiles(support.getTransferable());
                if (files.length == 1 && files[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.createNewPlaylist(files[0]);
                } else {
                    LibraryUtils.createNewPlaylist(files);
                }
            }
            this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
            LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        LibraryPlaylists.LibraryPlaylistsListCell cell = (LibraryPlaylists.LibraryPlaylistsListCell)this.list.getSelectedValue();
        if (cell != null && cell.getPlaylist() != null && cell.getPlaylist().getItems().size() > 0) {
            return new LibraryPlaylistsTableTransferable(cell.getPlaylist().getItems());
        }
        return null;
    }
}

