/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.tags.TagsReader;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public final class LibraryCoverArtPanel
extends JPanel {
    private final BufferedImage background = new BufferedImage(350, 350, 2);
    private final Image defaultCoverArt = GUIMediator.getThemeImage("default_cover_art").getImage();
    private Image coverArtImage;
    private TagsReader tagsReader;

    LibraryCoverArtPanel() {
        this.setTagsReader(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LibraryCoverArtPanel.this.setPrivateImage(LibraryCoverArtPanel.this.coverArtImage);
            }
        });
    }

    public LibraryCoverArtPanel setTagsReader(TagsReader reader) {
        if (this.tagsReader != null && reader != null && this.tagsReader.equals(reader)) {
            return this;
        }
        this.tagsReader = reader;
        return this;
    }

    public void setDefault() {
        this.tagsReader = null;
        LibraryUtils.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Image image = LibraryCoverArtPanel.this.retrieveImage();
                LibraryCoverArtPanel.this.setPrivateImage(image);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawImage(this.background, 0, 0, null);
    }

    public void asyncRetrieveImage() {
        if (this.tagsReader == null) {
            System.err.println("LibraryCoverArtPanel.asyncFetchImage() aborted. No tagsReader set. Check your logic");
            return;
        }
        LibraryUtils.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Image image = LibraryCoverArtPanel.this.retrieveImage();
                if (LibraryCoverArtPanel.this.tagsReader.getFile() != null) {
                    LibraryCoverArtPanel.this.setPrivateImage(image);
                }
            }
        });
    }

    private Image retrieveImage() {
        if (this.tagsReader == null || this.tagsReader.getFile() == null) {
            return this.defaultCoverArt;
        }
        return this.tagsReader.getArtwork();
    }

    private void setPrivateImage(Image image) {
        this.coverArtImage = image;
        if (this.coverArtImage == null) {
            this.coverArtImage = this.defaultCoverArt;
        }
        Graphics2D g2 = this.background.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setBackground(new Color(255, 255, 255, 0));
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.drawImage(this.coverArtImage, 0, 0, this.getWidth(), this.getHeight(), null);
        g2.dispose();
        this.repaint();
        this.getToolkit().sync();
    }
}

