/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.DirectoryHolder;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;

public abstract class AbstractDirectoryHolder
implements DirectoryHolder {
    Set<File> _hideFiles;

    @Override
    public File[] getFiles() {
        this._hideFiles = TorrentUtil.getIgnorableFiles();
        File[] files = this.getDirectory().listFiles(this);
        return files != null ? files : new File[]{};
    }

    @Override
    public boolean accept(File file) {
        if (this._hideFiles != null && (this._hideFiles.contains(file) || !this.isFileVisible(file) || file.getName().toLowerCase().equals(".ds_store") || this.isPartsFile(file))) {
            return false;
        }
        File parent = file.getParentFile();
        return parent != null && parent.equals(this.getDirectory());
    }

    private boolean isPartsFile(File f) {
        return f.getName().startsWith(".") && f.getName().endsWith(".parts");
    }

    protected boolean isFileVisible(File file) {
        return file != null && file.exists() && file.canRead() && !file.isHidden();
    }

    @Override
    public String getName() {
        return this.getDirectory().getName();
    }

    @Override
    public String getDescription() {
        return this.getDirectory().getAbsolutePath();
    }

    @Override
    public int size() {
        File[] files = this.getFiles();
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

