/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class SendFileProgressDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(SendFileProgressDialog.class);
    private JProgressBar _progressBar;
    private JButton _cancelButton;
    private Container _container;
    private File _preselectedFile;
    private final TorrentMakerListener torrentMakerListener;

    public SendFileProgressDialog(JFrame frame, File file) {
        this(frame);
        this._preselectedFile = file;
    }

    public SendFileProgressDialog(JFrame frame) {
        super(frame);
        this.setupUI();
        this.setLocationRelativeTo(frame);
        this.torrentMakerListener = new TorrentMakerListener();
    }

    protected void setupUI() {
        this.setupWindow();
        this.initProgressBar();
        this.initCancelButton();
    }

    private void setupWindow() {
        String itemType = I18n.tr("Preparing selection");
        this.setTitle(itemType + ", " + I18n.tr("please wait..."));
        Dimension prefDimension = new Dimension(512, 100);
        this.setSize(prefDimension);
        this.setMinimumSize(prefDimension);
        this.setPreferredSize(prefDimension);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SendFileProgressDialog.this.this_windowOpened();
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this._container = this.getContentPane();
        this._container.setLayout(new GridBagLayout());
    }

    private void initCancelButton() {
        this._cancelButton = new JButton(I18n.tr("Cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendFileProgressDialog.this.onCancelButton();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 22;
        c.insets = new Insets(10, 0, 10, 10);
        this._container.add((Component)this._cancelButton, c);
    }

    protected void onCancelButton() {
        this.dispose();
    }

    private void initProgressBar() {
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setStringPainted(true);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridwidth = -1;
        this._container.add((Component)this._progressBar, c);
    }

    protected void this_windowOpened() {
        if (this._preselectedFile == null) {
            this.chooseFile();
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this.onApprovedFileSelectionToSend(SendFileProgressDialog.this._preselectedFile.getAbsoluteFile());
                }
            }).start();
        }
    }

    public void chooseFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle(I18n.tr("Select the content you want to send"));
        fileChooser.setApproveButtonText(I18n.tr("Select"));
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            final File selectedFile = fileChooser.getSelectedFile();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this.onApprovedFileSelectionToSend(selectedFile.getAbsoluteFile());
                }
            }).start();
        } else if (result == 1) {
            this.onCancelButton();
        } else if (result == -1) {
            LOG.error("Error selecting the file");
        }
    }

    private void onApprovedFileSelectionToSend(File absoluteFile) {
        TorrentUtil.makeTorrentAndDownload(absoluteFile, this.torrentMakerListener, true);
    }

    private class TorrentMakerListener
    implements TorrentUtil.UITorrentMakerListener {
        private TorrentMakerListener() {
        }

        @Override
        public void onCreateTorrentError(final error_code ec) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this._progressBar.setString("Error: " + ec.message());
                }
            });
        }

        @Override
        public void beforeOpenForSeedInUIThread() {
            SendFileProgressDialog.this.dispose();
        }

        @Override
        public void onException() {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileProgressDialog.this._progressBar.setString("There was an error. Make sure the file/folder is not empty.");
                }
            });
        }
    }
}

