/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import com.limegroup.gnutella.gui.tables.TableActionLabel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public final class PaymentOptionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final Logger LOG = Logger.getLogger(PaymentOptionsRenderer.class);
    private static final ImageIcon bitcoin_enabled = GUIMediator.getThemeImage("bitcoin_enabled");
    private static final ImageIcon bitcoin_disabled = GUIMediator.getThemeImage("bitcoin_disabled");
    private static final ImageIcon paypal_enabled = GUIMediator.getThemeImage("paypal_enabled");
    private static final ImageIcon paypal_disabled = GUIMediator.getThemeImage("paypal_disabled");
    private final TableActionLabel labelBitcoin = new TableActionLabel(bitcoin_enabled, bitcoin_disabled);
    private final TableActionLabel labelPaypal = new TableActionLabel(paypal_enabled, paypal_disabled);
    private PaymentOptions paymentOptions;

    public PaymentOptionsRenderer() {
        this.setupUI();
    }

    private void setupUI() {
        this.setEnabled(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.labelBitcoin.setToolTipText(I18n.tr("Name your price, Send a Tip or Donation in") + " " + I18n.tr("bitcoins"));
        this.labelPaypal.setToolTipText(I18n.tr("Name your price, Send a Tip or Donation via Paypal"));
        this.initMouseListeners();
        this.initComponentsLayout();
    }

    private void initComponentsLayout() {
        this.setLayout(new MigLayout("gap 2px, fillx, center, insets 5px 5px 5px 5px", "[20px!][20px!]"));
        this.add((Component)this.labelBitcoin, "width 20px!, growx 0, aligny top, push");
        this.add((Component)this.labelPaypal, "width 20px!, growx 0, aligny top, push");
    }

    private void initMouseListeners() {
        this.labelBitcoin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PaymentOptionsRenderer.this.labelBitcoin_mouseReleased(e);
            }
        });
        this.labelPaypal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PaymentOptionsRenderer.this.labelPaypal_mouseReleased(e);
            }
        });
    }

    @Override
    protected void updateUIData(Object value, JTable table, int row, int column) {
        try {
            boolean showSolid = this.mouseIsOverRow(table, row);
            boolean gotPaymentOptions = false;
            if (value instanceof PaymentOptions) {
                gotPaymentOptions = this.paymentOptions != null;
                this.paymentOptions = (PaymentOptions)value;
            }
            this.labelBitcoin.updateActionIcon(gotPaymentOptions && !StringUtils.isNullOrEmpty(this.paymentOptions.bitcoin), showSolid);
            this.labelPaypal.updateActionIcon(gotPaymentOptions && !StringUtils.isNullOrEmpty(this.paymentOptions.paypalUrl), showSolid);
        }
        catch (Throwable t) {
            LOG.error("Unable to update UI data", t);
        }
    }

    private void openPaymentOptionsURL(PaymentOptions paymentOptions, PaymentOptions.PaymentMethod method) {
        String paymentOptionsUrl;
        if (method == PaymentOptions.PaymentMethod.PAYPAL && !StringUtils.isNullOrEmpty(paymentOptions.paypalUrl)) {
            paymentOptionsUrl = paymentOptions.paypalUrl;
        } else {
            String paymentOptionsJSON = UrlUtils.encode(JsonUtils.toJson(paymentOptions).replaceAll("\n", ""));
            String title = UrlUtils.encode(paymentOptions.getItemName());
            paymentOptionsUrl = "http://www.frostwire.com/tips/?method=" + method.toString() + "&po=" + paymentOptionsJSON + "&title=" + title;
        }
        GUIMediator.openURL(paymentOptionsUrl);
    }

    private void labelBitcoin_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.labelBitcoin.isActionEnabled() && this.paymentOptions != null && !StringUtils.isNullOrEmpty(this.paymentOptions.bitcoin)) {
            this.openPaymentOptionsURL(this.paymentOptions, PaymentOptions.PaymentMethod.BITCOIN);
        }
    }

    private void labelPaypal_mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.labelPaypal.isActionEnabled() && this.paymentOptions != null && !StringUtils.isNullOrEmpty(this.paymentOptions.paypalUrl)) {
            this.openPaymentOptionsURL(this.paymentOptions, PaymentOptions.PaymentMethod.PAYPAL);
        }
    }
}

